<?php

namespace App\Http\Controllers\Dashboard\Main;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\DoctorSchedule;
use App\Models\User;

use Hash;
use DB;

class UpdateController extends Controller
{
    public function index(Request $request)
    {	
        DB::beginTransaction();

    	$params = $request->only(['email']);
    	$user = User::find(auth()->user()->id);

    	if ($user->update($params)) {

            $params = auth()->user()->isDoctor() ? $request->only(['contact_number','bio']) : $request->only(['contact_number']);

            if (!$user->account->update($params)) {
                // Rollback and then redirect & back to form with errors
                DB::rollback();

                $params = [
                    'user_id' => auth()->user()->id, 
                    'activity' => 'Account Update',
                    'reference_id' => $user->account->id,
                    'table' => 'users',
                    'remarks' => 'Failed updating account.',
                ];
                
                $this->addLogs($params);

                return response()->json(['message' => $user->account->getErrors()]);
            }
            
            DB::commit();

    		$params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Account Update',
                'reference_id' => $user->id,
                'table' => 'users',
                'remarks' => 'Success updating account.',
            ];

       	 	$this->addLogs($params);

    		return response()->json(['message' => 'success'],200);	
    	}

    	$params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Account Update',
            'reference_id' => $user->id,
            'table' => 'users',
            'remarks' => 'Failed updating account.',
        ];
        
        $this->addLogs($params);

        return response()->json(['message' => $user->getErrors()]);
    }

    public function changePassword(Request $request)
    {
    	if ($request->current_password) {
            $params = $request->only(['current_password','password']);
            $user = User::find(auth()->user()->id);

            if (Hash::check($request->current_password, $user->password)) { 

                $params['password'] = Hash::make($request->password);

                if ($user->update($params)) {

                    $params = [
                        'user_id' => auth()->user()->id, 
                        'activity' => 'Account Change Password',
                        'reference_id' => $user->id,
                        'table' => 'users',
                        'remarks' => 'Success updating password.',
                    ];

                    $this->addLogs($params);

                    return response()->json(['message' => 'success'],200);  
                }

                $params = [
                    'user_id' => auth()->user()->id, 
                    'activity' => 'Account Change Password',
                    'reference_id' => $user->id,
                    'table' => 'users',
                    'remarks' => 'Failed updating password.',
                ];
                
                $this->addLogs($params);

                return response()->json(['message' => $user->getErrors()]);
            } 
            
            return response()->json(['message' => 'Current Password does not match our record']);
        }
    }

    // change schedules
    public function changeSchedules(Request $request)
    {
        $params = [
            'monday'    => $this->formatRequestTime($request->monday),
            'tuesday'   => $this->formatRequestTime($request->tuesday),
            'wednesday' => $this->formatRequestTime($request->wednesday),
            'thursday'  => $this->formatRequestTime($request->thursday),
            'friday'    => $this->formatRequestTime($request->friday),
            'saturday'  => $this->formatRequestTime($request->saturday),
            'sunday'    => $this->formatRequestTime($request->sunday),
        ];

        $schedule = DoctorSchedule::where('doctor_id', auth()->user()->account->id)->first();

        if (isset($schedule)) {
            if ($schedule->update($params)) {

                $params = [
                    'user_id' => auth()->user()->id, 
                    'activity' => 'Doctors Schedule Update',
                    'reference_id' => $schedule->id,
                    'table' => 'doctor_schedules',
                    'remarks' => 'Successfully updated doctor schedule.',
                ];

                $this->addLogs($params);

                return response()->json(['message' => 'success'],200);  
            }
        }

        $params['doctor_id'] = auth()->user()->account->id;
        $schedule = DoctorSchedule::create($params);
        
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Doctors Schedule Create',
            'reference_id' => $schedule->id,
            'table' => 'doctor_schedules',
            'remarks' => 'Successfully created doctor schedule.',
        ];

        $this->addLogs($params);

        return response()->json(['message' => 'success'],200);  

    }

    public function formatRequestTime($times)
    {
        $am = [];
        $pm = [];
        foreach ($times as $key => $time) {
            if ($key == 0 || $key == 1) {
               $am[] = ($time != null) ? $this->twelveHourFormat($time) : '00:00 AM';
            } else {
               $pm[] = ($time != null) ? $this->twelveHourFormat($time) : '00:00 PM';
            }
        }

        $implodeTime = '['.implode(" - ", $am).'] - ['.implode(" - ", $pm).']';
        $timeformat = '[00:00 AM - 00:00 AM] - [00:00 PM - 00:00 PM]';

        return $implodeTime == $timeformat ? null : $implodeTime;
    }

    // 12-hour clock format
    public function twelveHourFormat($time)
    {
        return date('h:i A', strtotime($time));
    }
}
