<?php

namespace App\Http\Controllers\Dashboard\Affiliate;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add External Classes
use Yajra\Datatables\Datatables;

//Add Models
use App\Models\Doctor;

class ViewController extends Controller
{
    public function index()
    {
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Affiliates',
            'reference_id' => null,
            'table' => 'doctors',
            'remarks' => 'Success viewing affiliates.',
        ];

        $this->addLogs($params);

    	return view('dashboard.affiliates.index');
    }

    public function affiliateGroupList()
    {	
    	$doctors = Doctor::select([
                        'doctors.professional_id',
                        'merchants.name',
                        'merchant_agreements.account_type',
                        'users.id',
                        'users.firstname',
                        'users.middlename',
                        'users.lastname',
                        'users.email',
                        'users.status',
	                ])
	            	->leftJoin('users', 'doctors.user_id', 'users.id')
                    ->leftJoin('merchants', 'doctors.merchant_id', 'merchants.id')
                    ->leftJoin('merchant_agreements', 'merchants.id', 'merchant_agreements.merchant_id')
                    ->where('merchant_agreements.account_type','group')
	                ->get();
        
        return Datatables::of($doctors)
            ->addIndexColumn()
            ->addColumn('name', function($doctor){
                $name = ucwords($doctor->firstname.' '.$doctor->middlename.' '.$doctor->lastname);
                $photo = (isset($doctor->image->path)) ? 
                            '<img src="'.config('app.AWS_BUCKET_URL').$doctor->image->path.'" class="rounded-circle mr-2" width="40px" height="40px">' : 
                            '<img src="admin_dashboard/img/default.png" class="rounded-circle mr-2" width="40px" height="40px">' ;
                return $photo.' '.$name;
            })
            ->addColumn('professional_id', function($doctor){
                return $doctor->professional_id;
            })
            ->addColumn('merchant', function($doctor){
                return $doctor->name;
            })
            ->addColumn('email', function($doctor){
                return $doctor->email;
            })
            ->addColumn('merchant_type', function($doctor){
                return $doctor->account_type;
            })
            ->addColumn('doctor_type', function($doctor){
                return 'doctor';
            })
            ->addColumn('status', function($doctor){
                $status = $doctor->status == 1 ? 
                    '<i class="mdi mdi-checkbox-blank-circle text-success"></i> Active' :
                    '<i class="mdi mdi-checkbox-blank-circle text-danger"></i> Not Active' ;
                return $status;
            })
            ->addColumn('action', function ($doctor){
                $button = '<a href='.route('merchants.doctors.view',base64_encode($doctor->id)).' id="view">
                                <button class="btn btn-sm btn-info mr-1"> 
                                    <i class="mdi mdi-eye"></i> View
                                </button>
                            </a>';
                $action = '<div style="display:flex">
                                '.$button.'
                           </div>';
                return $action;
            })
            ->escapeColumns([])->make(true);
    }

    public function affiliateIndividualList()
    {   
        $doctors = Doctor::select([
                        'doctors.professional_id',
                        'merchants.name',
                        'merchant_agreements.account_type',
                        'users.id',
                        'users.firstname',
                        'users.middlename',
                        'users.lastname',
                        'users.email',
                        'users.status',
                    ])
                    ->leftJoin('users', 'doctors.user_id', 'users.id')
                    ->leftJoin('merchants', 'doctors.merchant_id', 'merchants.id')
                    ->leftJoin('merchant_agreements', 'merchants.id', 'merchant_agreements.merchant_id')
                    ->where('merchant_agreements.account_type','individual')
                    ->get();
        
        return Datatables::of($doctors)
            ->addIndexColumn()
            ->addColumn('name', function($doctor){
                $name = ucwords($doctor->firstname.' '.$doctor->middlename.' '.$doctor->lastname);
                $photo = (isset($doctor->image->path)) ? 
                            '<img src="'.config('app.AWS_BUCKET_URL').$doctor->image->path.'" class="rounded-circle mr-2" width="40px" height="40px">' : 
                            '<img src="admin_dashboard/img/default.png" class="rounded-circle mr-2" width="40px" height="40px">' ;
                return $photo.' '.$name;
            })
            ->addColumn('professional_id', function($doctor){
                return $doctor->professional_id;
            })
            ->addColumn('merchant', function($doctor){
                return $doctor->name;
            })
            ->addColumn('email', function($doctor){
                return $doctor->email;
            })
            ->addColumn('merchant_type', function($doctor){
                return $doctor->account_type;
            })
            ->addColumn('doctor_type', function($doctor){
                return 'doctor';
            })
            ->addColumn('status', function($doctor){
                $status = $doctor->status == 1 ? 
                    '<i class="mdi mdi-checkbox-blank-circle text-success"></i> Active' :
                    '<i class="mdi mdi-checkbox-blank-circle text-danger"></i> Not Active' ;
                return $status;
            })
            ->addColumn('action', function ($doctor){
                $button = '<a href='.route('merchants.doctors.view',base64_encode($doctor->id)).' id="view">
                                <button class="btn btn-sm btn-info mr-1"> 
                                    <i class="mdi mdi-eye"></i> View
                                </button>
                            </a>';
                $action = '<div style="display:flex">
                                '.$button.'
                           </div>';
                return $action;
            })
            ->escapeColumns([])->make(true);
    }
}
