<?php

namespace App\Http\Controllers\Dashboard\Administration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\MerchantAccount;
use App\Models\MerchantCashier;
use App\Models\AdminAccount;
use App\Models\Cashier;
use App\Models\User;

use Redirect;
use Hash;
use DB;

class UpdateController extends Controller
{
    public function index(Request $request, $id)
    {
    	DB::beginTransaction();

        $userParams = $request->only(['firstname','middlename','lastname','username','email','password','usertype']);
        $user = User::find(base64_decode($id));
        $oldUsertype = $user->usertype;

        if ($user->update($userParams)) {

            $account = $request->only(['image','employee_number','department','contact_number']);

            if ($user->usertype == $oldUsertype) {

               if ($user->usertype == 'admin_cashier' || $user->usertype == 'cashier') {

                    $table = 'cashiers';
                    $cashier = Cashier::where('user_id', base64_decode($id))->first();

                    if (!$cashier->update($account)) {
                        // Rollback and then redirect & back to form with errors
                        DB::rollback();

                        $params = [
                            'user_id' => auth()->user()->id, 
                            'activity' => 'User Registration',
                            'reference_id' => null,
                            'table' => 'cashiers and users',
                            'remarks' => 'Error updating user.',
                        ];

                        $this->addLogs($params);

                        return Redirect::route('administration.users.edit', $id)
                            ->withErrors($cashier->getErrors())
                            ->withInput();
                    }

                } elseif ($user->usertype == 'merchant_admin') {
                  
                    $table = 'merchant_accounts';
                    $account['merchant_id'] = $request->merchant_id;
                    $merchant = MerchantAccount::where('user_id', base64_decode($id))->first();

                    // validate employee_number with same merchant_id
                    $this->customMerchantValidation($request, $merchant);

                    if (!$merchant->update($account)) {
                        // Rollback and then redirect & back to form with errors
                        DB::rollback();

                        $params = [
                            'user_id' => auth()->user()->id, 
                            'activity' => 'User Registration',
                            'reference_id' => null,
                            'table' => 'merchant_accounts and users',
                            'remarks' => 'Error registering user.',
                        ];

                        $this->addLogs($params);

                        return Redirect::route('administration.users.edit', $id)
                            ->withErrors($merchant->getErrors())
                            ->withInput();
                    }

                } elseif ($user->usertype == 'merchant_cashier') {

                    $table = 'merchant_cashiers';
                    $account['merchant_id'] = $request->merchant_id;
                    $cashier = MerchantCashier::where('user_id', base64_decode($id))->first();

                    // validate employee_number with same merchant_id
                    $this->customMerchantValidation($request, $cashier);

                    if (!$cashier->update($account)) {
                        // Rollback and then redirect & back to form with errors
                        DB::rollback();

                        $params = [
                            'user_id' => auth()->user()->id, 
                            'activity' => 'User Registration',
                            'reference_id' => null,
                            'table' => 'merchant_cashiers and users',
                            'remarks' => 'Error registering user.',
                        ];

                        $this->addLogs($params);

                        return Redirect::route('administration.users.edit', $id)
                            ->withErrors($cashier->getErrors())
                            ->withInput();
                    }

                } else {

                    $table = 'admin_accounts';
                    $admin = AdminAccount::where('user_id', base64_decode($id))->first();

                    if (!$admin->update($account)) {

                        DB::rollback();

                        $params = [
                            'user_id' => auth()->user()->id, 
                            'activity' => 'User Registration',
                            'reference_id' => null,
                            'table' => 'admin_accounts and users',
                            'remarks' => 'Error updating user.',
                        ];

                        $this->addLogs($params);

                        return Redirect::route('administration.users.edit', $id)
                                    ->withErrors($admin->getErrors())
                                    ->withInput();
                    }
                }

            } else{

                // Delete old user account
                $this->deleteOldAccount($oldUsertype, $user->id);
                $account['user_id'] = $user->id;

                if ($request->usertype == 'admin_cashier' || $request->usertype == 'cashier') {

                    $table = 'cashiers';
                    $account['cashier_id'] = $this->generateCashierId($request->usertype);
                    $cashier = new Cashier($account);

                    if (!$cashier->save()) {
                        // Rollback and then redirect & back to form with errors
                        DB::rollback();

                        $params = [
                            'user_id' => auth()->user()->id, 
                            'activity' => 'User Registration',
                            'reference_id' => null,
                            'table' => 'cashiers and users',
                            'remarks' => 'Error registering user.',
                        ];

                        $this->addLogs($params);

                        return Redirect::route('administration.users.edit', $id)
                            ->withErrors($cashier->getErrors())
                            ->withInput();
                    }

                } elseif ($request->usertype == 'merchant_admin') {
                    
                    $table = 'merchant_accounts';
                    $account['merchant_id'] = $request->merchant_id;
                    $merchant = new MerchantAccount($account);

                    if (!$merchant->save()) {
                        // Rollback and then redirect & back to form with errors
                        DB::rollback();

                        $params = [
                            'user_id' => auth()->user()->id, 
                            'activity' => 'User Registration',
                            'reference_id' => null,
                            'table' => 'merchant_accounts and users',
                            'remarks' => 'Error registering user.',
                        ];

                        $this->addLogs($params);

                        return Redirect::route('administration.users.edit', $id)
                            ->withErrors($merchant->getErrors())
                            ->withInput();
                    }

                } elseif ($request->usertype == 'merchant_cashier') {
                    
                    $table = 'merchant_cashiers';
                    $account['merchant_id'] = $request->merchant_id;
                    $account['cashier_id'] = $this->generateCashierId($request->usertype);
                    $cashier = new MerchantCashier($account);

                    if (!$cashier->save()) {
                        // Rollback and then redirect & back to form with errors
                        DB::rollback();

                        $params = [
                            'user_id' => auth()->user()->id, 
                            'activity' => 'User Registration',
                            'reference_id' => null,
                            'table' => 'merchant_cashiers and users',
                            'remarks' => 'Error registering user.',
                        ];

                        $this->addLogs($params);

                        return Redirect::route('administration.users.edit', $id)
                            ->withErrors($cashier->getErrors())
                            ->withInput();
                    }

                } else {

                    $table = 'admin_accounts';
                    $admin = new AdminAccount($account);
                    
                    if (!$admin->save()) {

                        DB::rollback();

                        $params = [
                            'user_id' => auth()->user()->id, 
                            'activity' => 'User Registration',
                            'reference_id' => null,
                            'table' => 'admin_accounts and users',
                            'remarks' => 'Error registering user.',
                        ];

                        $this->addLogs($params);

                        return Redirect::route('administration.users.edit', $id)
                                    ->withErrors($admin->getErrors())
                                    ->withInput();
                    }
                }
            }            

            //SAVE IMAGE TO S3
            $this->storeUserImage($request, $user->id);

            //ASSIGN ROLE
            $this->updateRole($user);
            
            DB::commit();

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'User Registration',
                'reference_id' => $user->id,
                'table' => $table.' and users',
                'remarks' => 'Successfully updated user.',
            ];

            $this->addLogs($params);

            return Redirect::route('administration.users')
                        ->with(['success' => 'Successfully updated new '.str_replace('_', ' ', $user->usertype)]);
        }

        return Redirect::route('administration.users.edit', $id)
                        ->withErrors($user->getErrors())
                        ->withInput();
        
    }

    public function status($id)
    {
        $user = User::find(base64_decode($id));

        if ($user->status == 1) {
        	
        	$user->update(['status' => 0]);

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'User Deactivation',
                'reference_id' => base64_decode($id),
                'table' => 'users',
                'remarks' => 'Success deactivating User.',
            ];
            
            $this->addLogs($params);

        	return response()->json(['message' => 'User deactivated successfully']);
        }

       	$user->update(['status' => 1]);

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'User Activation',
            'reference_id' => base64_decode($id),
            'table' => 'users',
            'remarks' => 'Success activating user.',
        ];

        $this->addLogs($params);

        return response()->json(['message' => 'User activated successfully']);
    }

    public function resetPassword($id)
    {
        $user = User::find(base64_decode($id));
        $user->update(['password' => Hash::make('pplus2020')]);

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'User Reset Password',
            'reference_id' => base64_decode($id),
            'table' => 'users',
            'remarks' => 'Success user reset password.',
        ];

        $this->addLogs($params);

        // Should send an email/text that his password is reset!
        // code...

        return response()->json(['message' => 'User Password reset successfully']);
    }
    
    public function deleteOldAccount($usertype, $id)
    {   
        if ($usertype == 'admin_cashier' || $usertype == 'cashier') {
            Cashier::where('user_id', $id)->delete();
        } elseif ($usertype == 'merchant_admin') {
            MerchantAccount::where('user_id', $id)->delete();
        } elseif ($usertype == 'merchant_cashier') {
            MerchantCashier::where('user_id', $id)->delete();
        } else {
            AdminAccount::where('user_id', $id)->delete();
        }
    }

    public function customMerchantValidation($request, $data)
    {
        return $request->validate([
                'employee_number' => 'required|unique:'.$data->getTable().',employee_number,'.$data->id.',id,merchant_id,'.$data->merchant_id,
            ]);
    }
}
