<?php

namespace App\Http\Controllers\Dashboard\Administration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\MerchantAccount;
use App\Models\MerchantCashier;
use App\Models\AdminAccount;
use App\Models\Cashier;
use App\Models\User;

use Redirect;
use Hash;
use DB;

class CreateController extends Controller
{
    public function index(Request $request)
    {
    	DB::beginTransaction();

    	$request->merge(['password' => Hash::make('pplus2020')]);
    	$userParams = $request->only(['firstname','middlename','lastname','username','email','password','usertype']);
    	$user = new User($userParams);

    	if ($user->save()) {

    		$account = $request->only(['image','employee_number','department','contact_number']);
    		$account['user_id'] = $user->id;

			if ($user->usertype == 'admin_cashier' || $user->usertype == 'cashier') {

    			$table = 'cashiers';
    			$account['cashier_id'] = $this->generateCashierId($user->usertype);
				$cashier = new Cashier($account);

				if (!$cashier->save()) {
    				// Rollback and then redirect & back to form with errors
					DB::rollback();

					$params = [
	                    'user_id' => auth()->user()->id, 
	                    'activity' => 'User Registration',
	                    'reference_id' => null,
	                    'table' => 'cashiers and users',
	                    'remarks' => 'Error registering user.',
	                ];

	                $this->addLogs($params);

					return Redirect::route('administration.users.add')
				        ->withErrors($cashier->getErrors())
				        ->withInput();
				}

			} elseif ($user->usertype == 'merchant_admin') {
				
    			$table = 'merchant_accounts';
				$account['merchant_id'] = $request->merchant_id;
				$merchant = new MerchantAccount($account);

				if (!$merchant->save()) {
    				// Rollback and then redirect & back to form with errors
					DB::rollback();

					$params = [
	                    'user_id' => auth()->user()->id, 
	                    'activity' => 'User Registration',
	                    'reference_id' => null,
	                    'table' => 'merchant_accounts and users',
	                    'remarks' => 'Error registering user.',
	                ];

	                $this->addLogs($params);

					return Redirect::route('administration.users.add')
				        ->withErrors($merchant->getErrors())
				        ->withInput();
				}

			} elseif ($user->usertype == 'merchant_cashier') {
				
    			$table = 'merchant_cashiers';
				$account['merchant_id'] = $request->merchant_id;
    			$account['cashier_id'] = $this->generateCashierId($user->usertype);
				$cashier = new MerchantCashier($account);

				if (!$cashier->save()) {
    				// Rollback and then redirect & back to form with errors
					DB::rollback();

					$params = [
	                    'user_id' => auth()->user()->id, 
	                    'activity' => 'User Registration',
	                    'reference_id' => null,
	                    'table' => 'merchant_cashiers and users',
	                    'remarks' => 'Error registering user.',
	                ];

	                $this->addLogs($params);

					return Redirect::route('administration.users.add')
				        ->withErrors($cashier->getErrors())
				        ->withInput();
				}

			} else {

    			$table = 'admin_accounts';
				$admin = new AdminAccount($account);
				
				if (!$admin->save()) {

					DB::rollback();

					$params = [
	                    'user_id' => auth()->user()->id, 
	                    'activity' => 'User Registration',
	                    'reference_id' => null,
	                    'table' => 'admin_accounts and users',
	                    'remarks' => 'Error registering user.',
	                ];

	                $this->addLogs($params);

					return Redirect::route('administration.users.add')
						        ->withErrors($admin->getErrors())
						        ->withInput();
				}
			}

            //SAVE IMAGE TO S3
            $this->storeUserImage($request, $user->id);
            
            //ASSIGN ROLE
            $this->assignRole($user);

			DB::commit();

			$params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'User Registration',
                'reference_id' => $user->id,
                'table' => $table.' and users',
                'remarks' => 'Successfully registered user.',
            ];

            $this->addLogs($params);

			return Redirect::route('administration.users')
						->with(['success' => 'Successfully added new '.str_replace('_', ' ', $user->usertype)]);
    	}

    	return Redirect::route('administration.users.add')
				        ->withErrors($user->getErrors())
				        ->withInput();
    }
}
