<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;

//Add Storage Class
use Illuminate\Support\Facades\Storage;

//Add Role Class
use Spatie\Permission\Models\Role;

//Add Models
use App\Models\MerchantCashier;
use App\Models\EstablishmentImage;
use App\Models\SpecialityImage;
use App\Models\PromotionImage;
use App\Models\MerchantImage;
use App\Models\ProductImage;
use App\Models\DoctorImage;
use App\Models\DriverImage;
use App\Models\UserImage;
use App\Models\Referral;
use App\Models\Cashier;
use App\Models\User;
use App\Models\Log;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function emitSocket($data) {
        $url = config('app.SOCKET_URL');

        $response = \Ixudra\Curl\Facades\Curl::to($url)
            ->withHeaders(array('Authorization' => 'test'))
            ->withData(json_encode($data, JSON_FORCE_OBJECT))->post();

        return $response;
    }

    // Store All User Images
    public function storeUserImage($request, $user_id) 
    {	
        if (isset($request->image)) {

            $params = [
                'auth_by' => $user_id,
                'title' => 'user_image',
                'path' => Storage::disk('s3')->put('web/img', $request->file('image')),
                'size' => $request->file('image')->getSize(),
            ];
            
            $user = UserImage::where('auth_by', $user_id)->first();

            if (isset($user)) {

                // Delete Image on S3
                Storage::disk('s3')->delete($user->path);
                $user->update($params);

            } else {

                UserImage::create($params);
            }
        }
    }

    // Store All Merchant Images
    public function storeMerchantImage($request, $merchant_id) 
    {   
        if (isset($request->image)) {

            $params = [
                'merchant_id' => $merchant_id,
                'title' => 'merchant_image',
                'path' => Storage::disk('s3')->put('web/img', $request->file('image')),
                'size' => $request->file('image')->getSize(),
            ];

            $merchant = MerchantImage::where('merchant_id', $merchant_id)->first();

            if (isset($merchant)) {

                // Delete Image on S3
                Storage::disk('s3')->delete($merchant->path);
                $merchant->update($params);

            } else {

                MerchantImage::create($params);
            }
        }
    }

    // Store All Multiple Promotions Images
    public function storePromotionImage($request, $promo_id) 
    {   
        if (isset($request->image)) {
            $params = [
                'promo_id' => $promo_id,
                'title' => 'promotion_image',
                'size' => $request->image->getSize(),
                'path' => Storage::disk('s3')->put('web/img', $request->image),
            ];

           PromotionImage::create($params);
        }

        if (isset($request->images)) {

            $images = array_slice($request->images, 0, 3);

            for ($i=0; $i < count($images); $i++) { 

                $params = [
                    'promo_id' => $promo_id,
                    'title' => 'promotion_image',
                    'size' => $request->images[$i]->getSize(),
                    'type' => 'regular',
                    'path' => Storage::disk('s3')->put('web/img', $request->images[$i]),
                ];

               PromotionImage::create($params);
            }
        }
    }

    // Store All Speciality Images
    public function storeSpecialityImage($request, $speciality_id) 
    {   
        if (isset($request->image)) {

            $params = [
                'speciality_id' => $speciality_id,
                'title' => 'speciality_image',
                'path' => Storage::disk('s3')->put('web/img', $request->file('image')),
                'size' => $request->file('image')->getSize(),
            ];

            $speciality = SpecialityImage::where('speciality_id', $speciality_id)->first();

            if (isset($speciality)) {

                // Delete Image on S3
                Storage::disk('s3')->delete($speciality->path);
                $speciality->update($params);

            } else {

                SpecialityImage::create($params);
            }
        }
    }

    // Store All Establishment Images
    public function storeEstablishmentImage($request, $establishment_id) 
    {   
        if (isset($request->image)) {

            $params = [
                'establishment_id' => $establishment_id,
                'title' => 'speciality_image',
                'path' => Storage::disk('s3')->put('web/img', $request->file('image')),
                'size' => $request->file('image')->getSize(),
            ];

            $establishment = EstablishmentImage::where('establishment_id', $establishment_id)->first();

            if (isset($establishment)) {

                // Delete Image on S3
                Storage::disk('s3')->delete($establishment->path);
                $establishment->update($params);

            } else {

                EstablishmentImage::create($params);
            }
        }
    }

    // Store All Doctor Images
    public function storeDoctorImage($request, $doctor_id) 
    {   
        if (isset($request->image)) {

            $params = [
                'doctor_id' => $doctor_id,
                'title' => 'doctor_image',
                'path' => Storage::disk('s3')->put('web/img', $request->file('image')),
                'size' => $request->file('image')->getSize(),
            ];

            $doctor = DoctorImage::where('doctor_id', $doctor_id)->first();

            if (isset($doctor)) {

                // Delete Image on S3
                Storage::disk('s3')->delete($doctor->path);
                $doctor->update($params);

            } else {

                DoctorImage::create($params);
            }
        }
    }

    // Store All Product Images
    public function storeProductImage($request, $product_id) 
    {   
        if (isset($request->image)) {

            $params = [
                'product_id' => $product_id,
                'title' => 'product_image',
                'path' => Storage::disk('s3')->put('web/img', $request->file('image')),
                'size' => $request->file('image')->getSize(),
            ];

            $product = ProductImage::where('product_id', $product_id)->first();

            if (isset($product)) {

                // Delete Image on S3
                Storage::disk('s3')->delete($product->path);
                $product->update($params);

            } else {

                ProductImage::create($params);
            }
        }
    }

    // Store All Driver Images
    public function storeDriverImage($request, $driver_id) 
    {   
        if (isset($request->image)) {

            $params = [
                'driver_id' => $driver_id,
                'title' => 'driver_image',
                'path' => Storage::disk('s3')->put('web/img', $request->file('image')),
                'size' => $request->file('image')->getSize(),
            ];

            $driver = DriverImage::where('driver_id', $driver_id)->first();

            if (isset($driver)) {

                // Delete Image on S3
                Storage::disk('s3')->delete($driver->path);
                $driver->update($params);

            } else {

                DriverImage::create($params);
            }
        }
    }

    // Generate Cashier ID
    public function generateCashierId($usertype)
    {           
        // get count keyword
        if ($usertype == 'merchant_cashier') {
            $keyword = 'CM:';
            $count = MerchantCashier::select(['cashier_id'])
                ->where('cashier_id','LIKE','%CM:%')
                ->orderBy('created_at','desc')
                ->count();
        } else {

            $keyword = $usertype == 'cashier' ? 'CR:' : 'CA:';
            $count = Cashier::select(['cashier_id'])
                ->where('cashier_id','LIKE','%'.$keyword.'%')
                ->orderBy('created_at','desc')
                ->count();
        }

        $sub = strlen((string)$count);
        $number = 9 - $sub;
        $string = str_pad($keyword, $number, "0", STR_PAD_RIGHT);
        $total = $count + 1;

        return $string.$total;
    }

    //creating users
    public function assignRole(User $user) 
    {
        Role::findOrCreate($user->usertype);
        $user->assignRole($user->usertype);
    }

    //updating users
    public function updateRole(User $user) 
    {
        Role::findOrCreate($user->usertype);
        $user->syncRoles($user->usertype);
    }

    public function addLogs($params) 
    {
        Log::create($params);
    }

    public function getReferrals($id) {
        return Referral::join('members', 'referrals.user_id', 'members.user_id')
                    ->where('user_upline_id', $id)
                    ->get();
    }

    public function getUser($id) {
        return User::find($id);
    }

    public function fix_keys($array) {
        $numberCheck = false;

        foreach ($array as $k => $val) {
            if (is_array($val)) $array[$k] = $this->fix_keys($val); //recurse
            if (is_numeric($k)) $numberCheck = true;
        }

        if ($numberCheck === true) {
            return array_values($array);
        } else {
            return $array;
        }
    }
}
