<?php

namespace App\Http\Controllers\Bayanihan\Referral;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\Member;

use Redirect;

class ViewController extends Controller
{
    public function index(Request $request, $code)
    {
        $member = Member::where('referral_code', base64_decode($code))->first();
        
        if (is_null($member)) {
            return abort(404);
        }

    	if (auth()->user()) {
            if (auth()->user()->isSuperAdmin() || auth()->user()->isAdmin() || auth()->user()->isAdminCashier()) {
                return Redirect::route('dashboard');      
            } 
            return Redirect::route('bayanihan');      
        }

        return view('bayanihan.referrals.index',[
            'code' => $member->referral_code
        ]);
    }

    public function register() {
        if(!auth()->user()) {
            return view('bayanihan.referrals.index');
        }
        return Redirect::route('bayanihan');
    }

    public function completeProfile()
    {   
        $member = Member::where('user_id', auth()->user()->id)->count();

        if ($member > 0) {
            return Redirect::route('bayanihan');
        }
        return view('bayanihan.referrals.add');
    }
}
