<?php

namespace App\Http\Controllers\Bayanihan\Referral;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\BayanihanPointSetting;
use App\Models\Referral;
use App\Models\Member;
use App\Models\User;

use Redirect;
use Hash;
use DB;

class CreateController extends Controller
{
    public function index(Request $request)
    {   
        $request->merge([
            'member_id'        => $this->generateMemberId(),
            'card_number'      => $this->generateCardNumber(),
            'referral_code'    => $this->generateReferralCode(),
            'member_type_id'   => 8,
        ]);

        DB::beginTransaction();

        $userParams = $request->only(['firstname','middlename','lastname']);
        $user = User::find(auth()->user()->id);

        if ($user->update($userParams)) {

            $params = $request->except(['_token','firstname','middlename','lastname']);
            $params['user_id'] = $user->id;
            $member = new Member($params);

            if (!$member->save()) {
                // Rollback and then redirect & back to form with errors
                DB::rollback();

                $params = [
                    'user_id' => auth()->user()->id, 
                    'activity' => 'Member Registration',
                    'reference_id' => null,
                    'table' => 'members and users',
                    'remarks' => 'Error registering member.',
                ];

                $this->addLogs($params);
                
                return Redirect::route('bayanihan.complete.profile')
                    ->withErrors($member->getErrors())
                    ->withInput();
            }

            //SAVE IMAGE TO S3
            $this->storeUserImage($request, $user->id);
            
            //ASSIGN ROLE
            $this->assignRole($user);

            // Add upline referral points
           // $this->addUplineReferralPoints($user);

            DB::commit();

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Member Registration',
                'reference_id' => $user->id,
                'table' => 'members and users',
                'remarks' => 'Successfully registered member.',
            ];

            $this->addLogs($params);

            return Redirect::route('bayanihan')->with(['success' => 'Successfully added new member']);
        }

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Member Update',
            'reference_id' => auth()->user()->id,
            'table' => 'members and users',
            'remarks' => 'Failed to update member.',
        ];

        $this->addLogs($params);

        return Redirect::route('bayanihan.complete.profile')
            ->withErrors($user->getErrors())
            ->withInput();
    }

    /*public function addUplineReferralPoints($user)
    {   
        $referral = Referral::where('user_id', $user->id)->first();
        if(isset($referral->user_upline_id)) {
            $member = Member::where('user_id', $referral->user_upline_id)->first();
        
            $points = $this->getActiveBayanihanPointSetting();

            // Add Referral Points
            $referralPoints = $member->referral_points + $points;
            $currentPoints = $member->current_points + $points;
            $totalPoints = $member->total_points + $points;

            $member->update([
                'referral_points' => $referralPoints,
                'current_points'  => $currentPoints,
                'total_points'    => $totalPoints,
            ]);
        }
    }*/

    // get active bayanihan point settings
    public function getActiveBayanihanPointSetting()
    {
        $points = BayanihanPointSetting::whereStatus(1)->value('points');

        return isset($points) ? $points : 50;
    }

    // Generate Member ID according based on last member_id
    public function generateMemberId()
    {
        $generated_id = Member::select(['member_id'])
            ->orderBy('created_at','desc')
            ->first();

        return $generated_id['member_id'] + 1;
    }

    // Generate Card Number
    public function generateCardNumber()
    {   
        $code = $this->generateNumericCode();
        $member = Member::where('card_number', $code)->first();

        if (isset($member)) {
            $this->generateNumericCode();
        }
        
        return $code;
    }

    // Generate 16 digits Numberic Code
    public function generateNumericCode()
    {
        $code = '';
        for($i = 0; $i < 16; $i++) { 
            $code .= mt_rand(0, 9); 
        }

        return $code;
    }

    // Generate Referral Code
    public function generateReferralCode()
    {
        $code = $this->generateAlphaNumeric(7);
        $member = Member::where('referral_code', $code)->first();

        if (isset($member)) {
            $this->generateAlphaNumeric(7);
        }    

        return $code;
    }

    // Generate Alpha Numberic
    public function generateAlphaNumeric($limit)
    {
        $code = substr(base_convert(sha1(uniqid(mt_rand())), 16, 36), 0, $limit);

        return strtoupper($code);
    }
}
