<?php

namespace App\Http\Controllers\Bayanihan\Main;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Redirect;

//Add Models
use App\Models\Referral;
use App\Models\User;
use App\Models\Member;

class ViewController extends Controller
{
	public function index($id = null)
	{
	   
		$params = [
			'user_id' => auth()->user()->id, 
			'activity' => 'Bayanihan',
			'reference_id' => null,
			'table' => 'members',
			'remarks' => 'Success viewing bayanihan.',
		];



		$user = Member::where("user_id", auth()->user()->id)->first();

	
		$this->addLogs($params);


		return view('bayanihan.main.index',[
					'id' => $id
		]);
	}

	public function getReferralList($id = null)
	{
		if($id == null) {
			$id = auth()->user()->id;
			$data = [
				"name" => ucwords(auth()->user()->firstname.' '.auth()->user()->middlename.' '.auth()->user()->lastname),
				"title" => auth()->user()->usertype,
				'photo' => isset(auth()->user()->images[0]->path) ? 
						config('app.AWS_BUCKET_URL').auth()->user()->images[0]->path : 
						asset('admin_dashboard/img/default.png')
			];
		} else {
			$id = base64_decode($id);

			$user = $this->getUser($id);
			$data = [
				"name" => ucwords($user->firstname.' '.$user->middlename.' '.$user->lastname),
				"title" => ucwords($user->usertype),
				'photo' => isset($user->images[0]->path) ? 
						config('app.AWS_BUCKET_URL').$user->images[0]->path : 
						asset('admin_dashboard/img/default.png')
			];
		}
		
		$main_referrals = $this->getReferrals($id);

		//Get Refferals
		$first_levels = [];
		$second_levels = [];
		$third_levels = [];
		$fourth_levels = [];
		$fifth_levels = [];

		$first_level_count = [];
		$second_level_count = [];
		$third_level_count = [];
		$fourth_level_count = [];
		$fifth_level_count = [];

		foreach ($main_referrals as $key => $main_referral) {
			if($main_referral->user_id == $id) {
				continue;
			}

			$user = $this->getUser($main_referral->user_id);
			$data["children"][$main_referral->user_id] = [
				"name" => ucwords($user->firstname.' '.$user->middlename.' '.$user->lastname),
				"title" => ucwords($user->usertype),
				'photo' => isset($user->images[0]->path) ? 
						config('app.AWS_BUCKET_URL').$user->images[0]->path : 
						asset('admin_dashboard/img/default.png')
			];
			$first_level_count[] = $main_referral->user_id;
			$first_levels[$id][$main_referral->user_id] = $main_referral->user_id;
		}
		
		if(count($first_levels) == 0) {
			$response = (Object)[
				"downlines" => $data,
				"first_level_count" => count($first_level_count),
				"second_level_count" => count($second_level_count),
				"third_level_count" => count($third_level_count),
				"fourth_level_count" => count($fourth_level_count),
				"fifth_level_count" => count($fifth_level_count)
			];

			return response()->json($response);
		}

		foreach ($first_levels[$id] as $key1 => $value) {
			$referral_1s = $this->getReferrals($value);
			foreach ($referral_1s as $key2 => $referral_1) {

				$user = $this->getUser($referral_1->user_id);
				$data["children"][$key1]["children"][$referral_1->user_id] = [
					"name" => ucwords($user->firstname.' '.$user->middlename.' '.$user->lastname),
					"title" => ucwords($user->usertype),
					'photo' => isset($user->images[0]->path) ? 
							config('app.AWS_BUCKET_URL').$user->images[0]->path : 
							asset('admin_dashboard/img/default.png')
				];
				$second_level_count[] = $referral_1->user_id;
				$second_levels[$value][$referral_1->user_id] = $referral_1->user_id;
			}
		}

		foreach ($second_levels as $key1 => $values) {
			foreach ($values as $key2 => $value) {
				$referral_2s = $this->getReferrals($value);
				foreach ($referral_2s as $key3 => $referral_2) {

					$user = $this->getUser($referral_2->user_id);
					$data["children"][$key1]["children"][$key2]["children"][$referral_2->user_id] = [
						"name" => ucwords($user->firstname.' '.$user->middlename.' '.$user->lastname),
						"title" => ucwords($user->usertype),
						'photo' => isset($user->images[0]->path) ? 
								config('app.AWS_BUCKET_URL').$user->images[0]->path : 
								asset('admin_dashboard/img/default.png')
					];

					$third_level_count[] = $referral_2->user_id;
					$third_levels[$key1][$value][$referral_2->user_id] = $referral_2->user_id;
				}
			}
		}

		foreach ($third_levels as $key1 => $third_level) {
			foreach ($third_level as $key2 => $values) {
				foreach ($values as $key => $value) {
					$referral_3s = $this->getReferrals($value);
					foreach ($referral_3s as $key3 => $referral_3) {
						$user = $this->getUser($referral_3->user_id);
						$data["children"][$key1]["children"][$key2]["children"][$key]["children"][$referral_3->user_id] = [
							"name" => ucwords($user->firstname.' '.$user->middlename.' '.$user->lastname),
							"title" => ucwords($user->usertype),
							'photo' => isset($user->images[0]->path) ? 
									config('app.AWS_BUCKET_URL').$user->images[0]->path : 
									asset('admin_dashboard/img/default.png')
						];

						$fourth_level_count[] = $referral_3->user_id;
						$fourth_levels[$key1][$key2][$value][$referral_3->user_id] = $referral_3->user_id;
					}
				}
			}
		}

		foreach ($fourth_levels as $key1 => $fourth_level) {
			foreach ($fourth_level as $key2 => $values) {
				foreach ($values as $key3 => $value) {
					foreach ($value as $key4 => $value2) {
						$referral_4s = $this->getReferrals($value2);
						foreach ($referral_4s as $key5 => $referral_4) {
							$user = $this->getUser($referral_4->user_id);
							$data["children"][$key1]["children"][$key2]["children"][$key3]["children"][$key4]["children"][$referral_3->user_id] = [
								"name" => ucwords($user->firstname.' '.$user->middlename.' '.$user->lastname),
								"title" => ucwords($user->usertype),
								'photo' => isset($user->images[0]->path) ? 
										config('app.AWS_BUCKET_URL').$user->images[0]->path : 
										asset('admin_dashboard/img/default.png')
							];

							$fifth_level_count[] = $referral_4->user_id;
						}
					}
				}
			}
		}

		$data = $this->fix_keys($data);

		$response = (Object)[
			"downlines" => $data,
			"first_level_count" => count($first_level_count),
			"second_level_count" => count($second_level_count),
			"third_level_count" => count($third_level_count),
			"fourth_level_count" => count($fourth_level_count),
			"fifth_level_count" => count($fifth_level_count)
		];

		return response()->json($response);
	}

	public function profile($id = null)
	{   
		$id = $id == null ? auth()->user()->id : base64_decode($id);

		$user = User::select([
				'users.*',
				'members.member_id',
				'members.birthdate',
				'members.mobile_number',
				'members.citizenship',
				'members.marital_status',
				'members.member_id',
				'members.card_number',
				'members.total_points',
				'members.redeemed',
				'members.address',
				'members.street_address',
				'members.building',
				'members.city',
				'members.province',
			])
			->join('members', 'users.id', 'members.user_id')
			->where('users.id', $id)
			->first();

		$user['image'] = isset($user->images[0]) ? config('app.AWS_BUCKET_URL').$user->images[0]->path :
				asset('admin_dashboard/img/default.png'); 

		$params = [
			'user_id' => $id, 
			'activity' => 'Profile',
			'reference_id' => $id,
			'table' => 'users and members',
			'remarks' => 'Success viewing profile.',
		];

		$this->addLogs($params);

		return view('bayanihan.main.profile',[
			'id'   => base64_encode($user->id),
			'user' => $user,
		]);
	}
}
