<?php

namespace App\Http\Controllers\Bayanihan\Main;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\Member;
use App\Models\User;

use Redirect;
use Hash;
use DB;

class UpdateController extends Controller
{
    public function index(Request $request)
    {	
    	DB::beginTransaction();

    	$params = $request->only(['firstname','middlename','lastname','email']);
    	$user = User::find(auth()->user()->id);

    	if ($user->update($params)) {

    		$params = $request->except(['firstname','middlename','lastname','email']);
            $member = Member::where('user_id', auth()->user()->id)->first();

			if ($member->update($params)) {
                // commit all update
                DB::commit();
                
                //ASSIGN ROLE
                $this->updateRole($user);

                //SAVE IMAGE TO S3
                $this->storeUserImage($request, auth()->user()->id);

                $params = [
                    'user_id' => auth()->user()->id, 
                    'activity' => 'Profile Member Update',
                    'reference_id' => auth()->user()->id,
                    'table' => 'members and users',
                    'remarks' => 'Successfully updated profile member.',
                ];

                $this->addLogs($params);

                return response()->json([
                        'message' => 'success',
                        'user'    => $user
                    ],200);  
			}
            
            // Rollback and then redirect & back to form with errors
            DB::rollback();

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Profile Member Update',
                'reference_id' => auth()->user()->id,
                'table' => 'members and users',
                'remarks' => 'Failed to update profile member.',
            ];

            $this->addLogs($params);

			return response()->json(['message' => $member->getErrors()]);
    	}

    	$params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Profile Member Update',
            'reference_id' => $user->id,
            'table' => 'members and users',
            'remarks' => 'Failed to update profile member.',
        ];

        $this->addLogs($params);

        return response()->json(['message' => $user->getErrors()]);
    }

    public function changePassword(Request $request)
    {
        if ($request->current_password) {
            $params = $request->only(['current_password','password']);
            $user = User::find(auth()->user()->id);

            if (Hash::check($request->current_password, $user->password)) { 

                $params['password'] = Hash::make($request->password);

                if ($user->update($params)) {

                    $params = [
                        'user_id' => auth()->user()->id, 
                        'activity' => 'Account Change Password',
                        'reference_id' => $user->id,
                        'table' => 'users',
                        'remarks' => 'Success updating password.',
                    ];

                    $this->addLogs($params);

                    return response()->json(['message' => 'success'],200);  
                }

                $params = [
                    'user_id' => auth()->user()->id, 
                    'activity' => 'Account Change Password',
                    'reference_id' => $user->id,
                    'table' => 'users',
                    'remarks' => 'Failed updating password.',
                ];
                
                $this->addLogs($params);

                return response()->json(['message' => $user->getErrors()]);
            } 
            
            return response()->json(['message' => 'Current Password does not match our record']);
        }
    }
}
