<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use App\Models\User;
use App\Models\Member;
use App\Models\Referral;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use App\Models\BayanihanPointSetting;
use App\Models\PointTransaction;
use App\Models\MemberPointTransactions;
use App\Mail\SuccessfulRegistration;
class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    // protected $redirectTo = RouteServiceProvider::HOME;
    protected $redirectTo = '/registrationsuccess';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        $data["mobile_number"] = '+63'.$data["mobile_number"];
        return Validator::make($data, [
            'firstname' => 'required|regex:/^[a-zA-Z\s]*$/',
            'lastname'  => 'required|regex:/^[a-zA-Z\s]*$/',
            'email'     => 'required|email|unique:users,email',
            'mobile_number' => 'required|unique:members,mobile_number',
            'username'  => 'required|regex:/^\S*$/u|min:6|unique:users,username',
            'password'  => ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\User
     */
    protected function create(array $data)
    {   
        if(isset($data['code'])) {
            $userUpline = Member::where('referral_code',base64_decode($data['code']))->first();

            if ($userUpline) {

                unset($data['code']);
                $data['password'] = Hash::make($data['password']);
                $data['usertype'] = 'member';

                $user = User::create($data);
                $this->assignRole($user);

                $params = [
                    'user_id'           => $user->id,
                    'member_type_id'    => 1,
                    'member_id'         => $this->generateMemberId(),
                    'birthdate'         => $data['birthdate'],
                    'gender'            => $this->generateRandomGender(),
                    'marital_status'    => "Select Marital Status",
                    'citizenship'       => "Specify Citizenship",
                    'mobile_number'     => '+63'.$data['mobile_number'],
                    'city'              => $data['city'],
                    'occupation'        => "None",
                    'address'           => "None",
                    'card_number'       => $this->generateCardNumber(),
                    'referral_code'     => $this->generateReferralCode(),
                    'registration_status' => "Regular",      
                ];

                $member = new Member($params);
                $member->save();

                // create upline id
                Referral::create([
                    'user_id'        => $user->id,
                    'user_upline_id' => $userUpline->user_id,
                ]);

                $points = $this->getActiveBayanihanPointSetting();

                // Add Referral Points
                $referralPoints = $userUpline->referral_points + $points;

                $userUpline->update([
                    'referral_points' => $referralPoints
                ]);

                MemberPointTransactions::create([

                    'reference_id' => "REF# : ".strtoupper(Str::random(10)),
                    'user_id'=> $user->id,
                    'points'=> 50,
                    'upline_user_id' => $userUpline->user_id,
                    'description' => 'New Referral',
                    'type'=> "new_referral_points"

                ]);  

                $user->notify(new SuccessfulRegistration());

                return $user;
            }
        } else {
            $data['password'] = Hash::make($data['password']);
            $data['usertype'] = 'member';
            $user = $this->add($data);
            return $user;
        }
        
        return abort(403);
    }

    /*public function add($data) {
        $user = User::create($data);
        $this->assignRole($user);

        $params = [
            'user_id'           => $user->id,
            'member_type_id'    => 1,
            'member_id'         => $this->generateMemberId(),
            'birthdate'         => $data['birthdate'],
            'gender'            => $this->generateRandomGender(),
            'marital_status'    => "Single",
            'citizenship'       => "Filipino",
            'mobile_number'     => '+63'.$data['mobile_number'],
            'city'              => $data['city'],
            'occupation'        => "None",
            'address'           => "None",
            'card_number'       => $this->generateCardNumber(),
            'referral_code'     => $this->generateReferralCode(),
            'registration_status' => "Regular",      
        ];

        $member = new Member($params);
        $member->save();

        return $user;
    }*/


    //Add Point
    // Generate Member ID according based on last member_id
    public function generateMemberId()
    {
        $generated_id = Member::select(['member_id'])
            ->orderBy('id','desc')
            ->first();

        return $generated_id['member_id'] + 1;
    }

    public function generateRandomMemberId() {
        return $randomNum = substr(str_shuffle("0123456789"), 0, 9);
    }

    // Generate Card Number
    public function generateCardNumber()
    {   
        $code = $this->generateNumericCode();
        $member = Member::where('card_number', $code)->first();

        if (isset($member)) {
            $this->generateNumericCode();
        }
        
        return $code;
    }

    // Generate 16 digits Numberic Code
    public function generateNumericCode()
    {
        $code = '';
        for($i = 0; $i < 16; $i++) { 
            $code .= mt_rand(0, 9); 
        }

        return $code;
    }

    public function generateRandomGender() {
        $genders = ["Male", "Female"];
        $randIndex = array_rand($genders);
        return $genders[$randIndex];
    }

    // Generate Referral Code
    public function generateReferralCode()
    {
        $code = $this->generateAlphaNumeric(7);
        $member = Member::where('referral_code', $code)->first();

        if (isset($member)) {
            $this->generateAlphaNumeric(7);
        }    

        return $code;
    }

    // Generate Alpha Numberic
    public function generateAlphaNumeric($limit)
    {
        $code = substr(base_convert(sha1(uniqid(mt_rand())), 16, 36), 0, $limit);

        return strtoupper($code);
    }

     public function getActiveBayanihanPointSetting()
    {
        $points = BayanihanPointSetting::whereStatus(1)->value('points');

        return isset($points) ? $points : 50;
    }
}
