<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Redirect;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */

    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    // custom username 
    public function username()
    {
        $field = (filter_var(request()->username, FILTER_VALIDATE_EMAIL) || !request()->username) ? 'email' : 'username';
        request()->merge([$field => request()->username]);
        return $field;
    }

    // Custom authenticated redirection user
    protected function authenticated(Request $request, $user)
    {   
        if($user->status == 0) {
            $message = 'Account already deactivated.';
            return $this->authenticatedLogout($request, $message);
        }   

        if ($user->usertype == 'member') {
           return Redirect::route('bayanihan');
        }

        if ($user->usertype == 'merchant_admin') {
            // check merchant if date expired
            if (auth()->user()->account->merchant->date_end <= date('Y-m-d', strtotime(Carbon::now()))) {
                $message = 'This account already deactivated. Please contact administrator';
                return $this->authenticatedLogout($request, $message);
            }
        }
    }

    //custom authenticated logout
    public function authenticatedLogout($request, $message)
    {
        $this->guard()->logout();
        $request->session()->invalidate();
        return redirect('/login')
            ->withInput()
            ->withErrors(['username' => $message]);
    }
}
