<?php

//Add Models
use App\Models\Promotion;
use App\Models\Merchant;
use App\Models\Product;
use App\Models\User;

	function getFileName($name,$file)
	{
	   return str_replace(" ","_", $name).'.' .strtolower($file->extension());
	}

	// get pending promotions count 
	function getPromotionCount()
	{	
		if (auth()->user()->isMerchantAdmin()) {
			$promotions = Promotion::select(['id'])
				->where('merchant_id', auth()->user()->account->merchant_id)
		        ->where('status', 0)
		        ->count();
		} else {
			$promotions = Promotion::select(['id'])
		        ->where('status', 0)
		        ->count();
		}
		
	    return $promotions;
	}

	// get pending product count 
	function getProductCount()
	{	
		if (auth()->user()->isMerchantAdmin()) {
			$product = Product::select(['id'])
				->where('merchant_id', auth()->user()->account->merchant_id)
		        ->where('status', 0)
		        ->count();
		} else {
			$product = Product::select(['id'])
		        ->where('status', 0)
		        ->count();
		}
		
	    return $product;
	}

	// get bayanhihan user
	function getBayanihanUser($id)
	{
		$user = User::select([
	                'users.*',
	                'members.member_id',
	                'members.total_points',
	                'members.redeemed',
	            ])
	            ->join('members', 'users.id', 'members.user_id')
	            ->where('users.id', base64_decode($id))
	            ->first();

	    return $user;
	}

	// get wallet balance
	function getWalletBalance()
	{	
		if (auth()->user()->isMerchantAdmin()) {
			$merchant = Merchant::find(auth()->user()->account->merchant_id);

			return $merchant->getWalletBalance();
		}
	}

	// get wallet balance
	function getWalletMaintainingBalance()
	{
		if (auth()->user()->isMerchantAdmin()) {
			$merchant = Merchant::find(auth()->user()->account->merchant_id);

			return $merchant->mb_amount * ($merchant->mb_percent / 100);
		}
	}