var express = require('express');
var socket = require('socket.io');
var bodyParser = require('body-parser');

//App setup
var app = express();

// environment variables
process.env.NODE_ENV = 'development';

// config variables
const config = require('./config/config.js');

app.use(bodyParser.urlencoded({ extended: true }));
app.use(bodyParser.json());
app.use(function (req, res, next) {
	res.setHeader('Access-Control-Allow-Origin', '*');
	res.setHeader('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');
	res.setHeader('Access-Control-Allow-Headers', 'X-Requested-With,Authorization,Content-Type');
	res.setHeader('Access-Control-Allow-Credentials', true);
	next();
});

var server = app.listen(global.gConfig.port, function() {
	console.log('listening to port '+ global.gConfig.port);
});

//Socket setup
var io = socket(server);
var router = express.Router();

app.get('/', function(req, res){
  	res.status(404).send({success: false, message: "Invalid Routes"});
});

app.post('/api/send', function(req, res){
	var data = req.body;
	delete data['0'];
	var jsonString = Object.keys(data)[0];
	console.log(jsonString);
	var json = JSON.parse(jsonString);
	var method = json.function + "=" + json.function_id;
	console.log(method);

	delete json.function;
	delete json.function_id;
  	io.emit(method, json);
  	res.status(200).send({success: true, message: "Success"});
});

io.on('connection', function(socket) {
	socket.on('DRIVER_LOCATION_UPDATE', function(data) {
		var location = {
			"heading" : data.position.heading,
			"latitude": data.position.latitude,
			"longitude": data.position.longitude
		};

		var method = "DELIVERY_DRIVER_LOCATION="+data.deliveryId;
		if(data.deliveryId != null) {
			updateLocation(method, location);
		}
	});
});

function updateLocation(method, location) {
	io.emit(method, location);
}

// router.use(function(req, res, next) {
// 	var authHeader = req.headers['authorization'];
// 	if(authHeader){
// 		if(authHeader == global.gConfig.api_key) {
// 			next();
// 		} else {
// 			return res.status(401).send({ success: false, message: 'Invalid Token' });
// 		}
// 	}else{
// 		return res.status(400).send({ success: false, message: 'No token provided' });
// 	}
// });

// app.use('/api', router);