<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
Route::get('merchantWallet/{id}', 'Api\Member\ViewController@merchantWallet');
Route::post('checkUpdate', 'Api\Updater\ViewController@index');

Route::post('forgot/password', 'Api\Auth\ForgotPasswordController@send')->name('forgot.password');

Route::group(['prefix' => 'auth'], function () {
    Route::post('login', 'Api\Auth\ViewController@index');

    Route::group(['middleware' => 'auth:api'], function () {
    	Route::post('updatePassword', 'Api\Auth\UpdateController@index');
    });
});

Route::group(['middleware' => 'auth:api'], function () {
	//Member
    Route::get('member/{id}', 'Api\Member\ViewController@index');
    Route::post('member/submit', 'Api\Member\CreateController@index');

    //Promos
    Route::get('promos', 'Api\Promos\ViewController@index');
    Route::get('promo/{promo_code}/{merchant_id}/{member_id}', 'Api\Promos\ViewController@getPromo');
    Route::post('promo/verify', 'Api\Promos\CreateController@index');

    //Transactions
    Route::post('transactions', 'Api\Transactions\ViewController@index');
    Route::post('transactions/update', 'Api\Transactions\UpdateController@index');

    Route::get('authenticate', 'Api\Auth\ViewController@user');
});
