<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class PointSetting extends Model
{
 	use ValidatingTrait;

    protected $fillable = [
        'merchant_id', 
        'rebate', 
        'system', 
        'accumulated', 
        'advocacy', 
        'member', 
        'upline', 
        'upline_number',
        'status',
    ];

    protected $rules = [
        'merchant_id'  => 'required|integer', 
        'rebate'       => 'required|integer', 
        'system'       => 'required|integer', 
        'accumulated'  => 'required|integer', 
        'advocacy'     => 'required|integer', 
        'member'       => 'required|integer', 
        'upline'       => 'required|integer', 
        'upline_number'=> 'required|integer', 
        'status'       => 'nullable|in:0,1',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }
}
