<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class Point extends Model
{
 	use ValidatingTrait;

 	protected $fillable = [
        'point_setting_id', 
        'merchant_id',
        'user_id', 
        'reference',
        'amount',
        'points',
        'rebate',
        'system',
        'upline_points',
        'accumulated',
        'advocacy',
        'cashier_id',
        'payment_type',
        'txn_id'
    ];

    protected $rules = [
        'point_setting_id'  => 'required|integer', 
        'merchant_id'       => 'required|integer', 
        'user_id'  		=> 'required|integer', 
        'reference'  		=> 'required|string', 
        'amount'  			=> 'required',
        'points'			=> 'required',
        'rebate'			=> 'required',
        'system'			=> 'required',
        'upline_points'		=> 'required',
        'accumulated'		=> 'required',
        'advocacy'			=> 'required',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function user() {
        return $this->hasOne(User::class, 'id', 'user_id');
    }
}