<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class MerchantWallet extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'merchant_id',
        'amount',
        'description',
        'reference',
        'remarks',
    ];

    protected $rules = [
        'merchant_id'       => 'required|integer',
        'amount'            => 'required|integer',
        'description'       => 'required|string',
        'reference'       	=> 'required|regex:/^[a-zA-Z\s]*$/',
        'remarks'           => 'required|regex:/^[a-zA-Z\s]*$/',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function merchant()
    {
        return $this->hasOne(Merchant::class, 'id', 'merchant_id');
    }
}
