<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class AreaCode extends Model
{
	use ValidatingTrait;
    
    protected $fillable = [
        'area_name', 
        'area_code', 
        'status',
    ];

    protected $rules = [
        'area_name' => 'required|string|unique:area_codes,area_name',
        'area_code' => 'required|string',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }
}
