<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;

//Add Storage Class
use Illuminate\Support\Facades\Storage;

use App\Models\Member;
use App\Models\Promotion;
use App\Models\PromotionLog;
use App\Models\PointImage;
use App\Models\PointHistory;
use Carbon\Carbon;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function emitSocket($data) {
        $url = config('app.SOCKET_URL');

        $response = \Ixudra\Curl\Facades\Curl::to($url)
            ->withHeaders(array('Authorization' => 'test'))
            ->withData(json_encode($data, JSON_FORCE_OBJECT))->post();

        \Log::info(json_encode($data, JSON_FORCE_OBJECT));
        
        return $response;
    }

    public function getMemberStatus($member_id) {
    	$member = Member::where('user_id', $member_id)->first();
    	return $member;
    }

    public function getMember($user_id) {
        $member = Member::where('user_id', $user_id)->first();
        return $member;
    }

    public function updateReferralPoints($data, $user_id) {
        $test = Member::where('user_id', $user_id)->update($data);
        // \Log::info("SHERWIN 222 ".json_encode($test)."ID ".$user_id);
        // $history = [
        //     "reference" => $or_number,
        //     "user_id" => $user_id,
        //     "points" => $points,
        //     "type" => "member_purchase",
        //     "description" => "Item purchase",
        //     "point_id" => $point_id
        // ];
        // PointHistory::create($history);
    }

    public function successResponse($message = null, $data) {
    	return response()->json([
    		"status" => "SUCCESS",
    		"message" => $message,
    		"data" => $data
    	], 200);
    }

    public function failResponse($message) {
    	return response()->json([
    		"status" => "ERROR",
    		"message" => $message
    	], 500);
    }


    public function errorResponse($message, $errors = null, $errorCode = "ValidationError") {
    	return response()->json([
    		"status" => "FAIL",
    		"message" => $message,
    		"error" => [
    			"code" => $errorCode,
    			"message" => $message,
    			"errors" => $errors
    		]
    	], 500);
    }

    public function getPromoAvailability($code) {
		$promo = Promotion::whereStatus(1)
			->where('promotions.promo_code', $code)
			->where('promotions.date_start', '<=', now())
			->where('promotions.date_end','>=', now())->first();

        if(!$promo) {
            return [
                "availability" => false
            ];
        }

		$promotion_logs = PromotionLog::where('promo_id', $promo->id)->get();

		if(count($promotion_logs) > 0) {
			$quantity = (int)$promo->quantity - count($promotion_logs);
			$sum_points = 0;
			foreach($promotion_logs as $key => $promotion_log) {
				$sum_points += $promotion_log->points_amount;
			}
			$remaining_allocation = (double)$promo->allocation_amount - (double)$sum_points;

			if($quantity <= 0 || $remaining_allocation <= 0) {
				return [
					"availability" => false
				];
			}
		}
        $promo_type = 0;
        if($promo->item_type == "points_of_payment") {
            $promo_type = 1;
        }

		$response = [
            "id" => $promo->id, 
			"promoCode" => $promo->promo_code, 
		    "availability" => true,
		    "points_as_payment" => $promo_type,
		    "points_required" => $promo->points_required,
		    "remainingAllocation" => $promo->allocation_amount,
		    "dateExpiry" => $promo->date_end,
		];

		return $response;
	}

    // Store All Multiple Point Images
    public function storePointImage($request, $point_id) 
    {   
        if (isset($request->images)) {
            for ($i=0; $i < count($request->images); $i++) { 
                $image = "data:image/jpeg;base64, ".$request->images[$i]["image"];  // your base64 encoded
                $data = explode(',', $image);
                $current_timestamp = Carbon::now()->timestamp;
                $imageName = rand().'.jpg';
                $filenametostore = 'web/img/'. $imageName;

                $params = [
                    'point_id' => $point_id,
                    'title' => 'point_receipt',
                    'size' => strlen(base64_decode($request->images[$i]["image"])),
                    'path' => $filenametostore,
                ];

                PointImage::create($params);
                Storage::disk('s3')->put($filenametostore, base64_decode($data[1]));
            }
        }
    }

    public function countDecimals($number) {
    	return strlen(strrchr($number, '.'))-1;
    }
}
