<?php

namespace App\Http\Controllers\Api\Transactions;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Point;

class ViewController extends Controller
{
    public function index(Request $request) {
    	$transactions = Point::where('merchant_id' , auth()->user()->account->merchant_id)
    						->where('reference',$request->orNumber)
    						->orderBy('status', 'asc')
    						->orderBy('created_at','desc')->get();

    	$data = [];
    	foreach ($transactions as $key => $transaction) {
    		$data[] = array(
    			"reference" => $transaction->reference,
	    		"id" => (string)$transaction->id,
	    		"amount" => (double)$transaction->amount,
	    		"createdAt" => $transaction->created_at->format('F d, Y'),
	    		"paymentType" => ucfirst($transaction->payment_type),
                "txnId" => $transaction->txn_id,
	    		"userId" => (string)$transaction->user_id,
	    		"memberName" => $transaction->user->firstname.' '. $transaction->user->lastname,
	    		"merchantId" => (string)$transaction->merchant_id,
	    		"status" => $transaction->status
    		);
    	}

    	return $this->successResponse(null, $data);	
    }
}
