<?php

namespace App\Http\Controllers\Api\Transactions;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Point;
use App\Models\Member;
use App\Models\PointHistory;
use DB;

class UpdateController extends Controller
{
    public function index(Request $request) {
    	$point = Point::find($request->id);
    	$point->status = "void";
    	$point->save();

    	$transactions = Point::where('merchant_id' , auth()->user()->account->merchant_id)
    						->where('reference',$request->orNumber)
    						->orderBy('status', 'asc')
    						->orderBy('created_at','desc')->get();

    	$data = [];
    	foreach ($transactions as $key => $transaction) {
    		$data[] = array(
    			"reference" => $transaction->reference,
	    		"id" => (string)$transaction->id,
	    		"amount" => (double)$transaction->amount,
	    		"createdAt" => $transaction->created_at->format('F d, Y'),
	    		"paymentType" => ucfirst($transaction->payment_type),
	    		"userId" => (string)$transaction->user_id,
	    		"memberName" => $transaction->user->firstname.' '. $transaction->user->lastname,
	    		"merchantId" => (string)$transaction->merchant_id,
	    		"status" => $transaction->status
    		);
    	}


    	$point_histories = PointHistory::where('point_id', $request->id)->get();
    	foreach ($point_histories as $key => $point_history) {
    		DB::table('members')
    			->where('user_id', $point_history->user_id)
    			->decrement('current_points', (int)$point_history->points);

    		DB::table('members')
    			->where('user_id', $point_history->user_id)
    			->decrement('total_points', (int)$point_history->points);


    		$history = [
	            "reference" => "CASHIER VOID",
	            "user_id" => $point_history->user_id,
	            "points" => "-".$point_history->points,
	            "type" => "member_void",
	            "description" => "PURCHASE VOID",
	            "point_id" => $request->id
	        ];
	        PointHistory::create($history);
    	}

    	return $this->successResponse(null, $data);	
    }
}
