<?php

namespace App\Http\Controllers\Api\Promos;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Promotion;
use App\Models\PromotionLog;

class ViewController extends Controller
{
    public function index() {
    	$promotions = Promotion::whereStatus(1)->where('merchant_id',auth()->user()->account->merchant_id)->where('date_start','<=', now())->where('date_end','>=', now())->get();
    	$data = [];

    	foreach ($promotions as $key => $promo) {
    		$promotion_logs_quantity = PromotionLog::where('promo_id', $promo->id)->get();

    		$allocation_amount = (isset($promotion_logs_quantity->allocation_amount)) ? $promotion_logs_quantity->allocation_amount : 0;
    		$points_amount = (isset($promotion_logs_quantity->points_amount)) ? $promotion_logs_quantity->points_amount : 0;
    		$quantity = (int)$promo->quantity - (int)count($promotion_logs_quantity);

    		$data[] = [
    			"id" => (string)$promo->id,
	            "code" => $promo->promo_code,
	            "type" => ($promo->item_type == "points_of_payment") ? "Pts. as Payment" : ucfirst($promo->item_type),
	            "imageUrl" => null,
	            "title" => $promo->description,
	            "content" => $promo->content,
	            "canPointsAsPayment" => ($promo->item_type == "points_of_payment") ? true : false,
	            "availability" => [
	            	"quantity" => $quantity,
	                "backgroundColor" => $this->getPromoBackgroundColor($promo->quantity, $quantity),
	                "remainingAllocation" => (double)$allocation_amount - (double)$points_amount,
	                "dateExpiry" => $promo->date_end->format('F d, Y')
	            ]
    		];
    	}

    	return $this->successResponse(null, $data);	
    }

    public function getPromo($code, $merchant_id, $member_id) {
    	$partial_code = explode("-", $code);
    	$voucher_code = $partial_code[0];
    	$amount = (isset($partial_code[1])) ? $partial_code[1] : null;

    	$promo = Promotion::join('merchants','merchants.id','promotions.merchant_id')
    		->select('promotions.id','promotions.promo_code','promotions.item_type','promotions.description','promotions.content','promotions.quantity','promotions.points_as_payment','promotions.date_end','promotions.allocation_amount')
    		->where('promotions.promo_code', $voucher_code)
    		->where('promotions.merchant_id', $merchant_id)
    		->where('promotions.date_end','>=', now())->first();

    	if($promo == null) {
    		$error = [
    			"field" => "voucherCode",
    			"message" => "No offer found in this voucher code."
    		];
    		return $this->failResponse($error["message"]);
    	}
    	$availability = $this->getPromoAvailability($voucher_code);

    	if($availability["availability"] == false) {
    		$error = [
    			"field" => "voucherCode",
    			"message" => "This offer is not available."
    		];
    		return $this->failResponse($error["message"]);
    	}

    	if($availability["points_as_payment"] == 1) {
    		$member = $this->getMemberStatus($member_id);

    		if($member->registration_status == 'unverified') {
    			$error = [
	    			"field" => "voucherCode",
	    			"message" => "Associate Members cannot avail Points as Payment."
	    		];
	    		return $this->failResponse($error["message"]);
    		}
    		if(!isset($partial_code[1]) || !isset($partial_code[0])) {
    			$error = [
	    			"field" => "voucherCode",
	    			"message" => "Please enter the amount of points after the dash(-)."
	    		];
	    		return $this->failResponse($error["message"]);
    		}
    		if($this->countDecimals($partial_code[1]) > 2) {
    			\Log::info("STEP 12");
    			$error = [
	    			"field" => "voucherCode",
	    			"message" => "Points must not contain 3 or more decimals.\neg. CODE-50.75"
	    		];
	    		return $this->failResponse($error["message"]);
    		}
    		if($partial_code[1] == 0) {
    			$error = [
	    			"field" => "voucherCode",
	    			"message" => "Please enter a valid amount of points."
	    		];
	    		return $this->failResponse($error["message"]);
    		}
    		if($partial_code[1] > $member->current_points) {
    			$error = [
	    			"field" => "voucherCode",
	    			"message" => "Cannot verify this voucher. The amount you have entered is higher than the member's current points.\n Points to be Deducted: ".$partial_code[1]." Current Points: ".$member->current_points.""
	    		];
	    		return $this->failResponse($error["message"]);
    		}
    		if($partial_code[1] > $availability["remainingAllocation"]) {
    			$error = [
	    			"field" => "voucherCode",
	    			"message" => "Cannot verify this voucher. The remaining allocation for this offer cannot accomodate more than ".$availability["remainingAllocation"].". Please enter ".$availability["remainingAllocation"]." or below in points as payment amount."
	    		];
	    		return $this->failResponse($error["message"]);
    		}
    	} else if(substr_count($code,"-") > 0) {
    		$error = [
    			"field" => "voucherCode",
    			"message" => "This offer is not applicable for Points as Payment. Remove the dash(-) and the amount."
    		];
    		return $this->failResponse($error["message"]);
    	}
		$promotion_logs_quantity = PromotionLog::where('promo_id', $promo->id)->get();
		$sum_points_amount = 0;
		foreach ($promotion_logs_quantity as $key => $promotion_log) {
			$sum_points_amount += $promotion_log->points_amount;
		}
		$quantity = (int)$promo->quantity - count($promotion_logs_quantity);
		$remaining_allocation = (double)$promo->allocation_amount - (double)$sum_points_amount;
		$data = [
			"id" => $code,
			"embeddedAmount" => $amount,
			"promo" => [
			    "id" => (string)$promo->id,
			    "code" => $voucher_code,
			    "type" => ($promo->item_type == "points_of_payment") ? "Pts. as Payment" : ucfirst($promo->item_type),
			    "imageUrl" => null,
			    "title" => $promo->description,
	            "content" => $promo->content,
			    "canPointsAsPayment" => ($promo->item_type == "points_of_payment") ? true : false,
			    "availability" => [
			        "quantity" => $quantity,
	                "backgroundColor" => $this->getPromoBackgroundColor($promo->quantity, $quantity),
	                "remainingAllocation" => $remaining_allocation,
	                "dateExpiry" => $promo->date_end->format('F d, Y')
			    ]
			]
		];
    	return $this->successResponse(null, $data);	
    }

    public function getPromoBackgroundColor($total, $available) {
	  	// Threshold
	  	// (0xFF4CAF50)Green = 25-100%
	  	// (0xFFF57F17)Yellow = 25% below
	  	// (0xFFF44336)Red = 0

	  	$percentage = ($available / $total) * 100;

	  	if ($percentage >= 25) {
	    	return 0xFF4CAF50;
	  	} else if ($percentage > 0 && $percentage < 25) {
	    	return 0xFFF9A825;
	  	} else {
	    	return 0xFFF44336;
	  	}
	}
}
