<?php

namespace App\Http\Controllers\Api\Member;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Member;
use App\Models\User;
use App\Models\MerchantWallet;
use App\Models\Merchant;

class ViewController extends Controller
{
    public function index($id) {
        if(strlen($id) != 19) {
            $array = explode("-", $id);
            if(count($array) > 1) {
                unset($array[0]);
            }
            $array = array_values($array);
            $id_array = [];
            foreach ($array as $key => $value) {
                if($key == 0) {
                    $id_array[] = str_replace(" ","",$value);
                }
                else {
                    $id_array[] = "-".str_replace(" ","",$value);
                }
            }
            $id = join($id_array);
        }
        
    	$member = Member::join('users', 'users.id', 'members.user_id')->select('members.user_id as id','members.current_points','members.registration_status','users.firstname','users.middlename','users.lastname',)->where('card_number', $id)->first();

        if($member) {
            $data = (Object)[
                "currentPoints" => (double)$member->current_points,
                "id" => (string)$member->id,
                "type" => ($member->registration_status == 'unverified') ? "Regular Member" : "Premium Member",
                "cardNumber" => (string)$id,
                "firstName" => $member->firstname,
                "middleName" => $member->middlename,
                "lastName" => $member->lastname
            ];

            return $this->successResponse(null, $data);
        }
        
        $error = [
            "field" => "cardNumber",
            "message" => "No member found"
        ];
        return $this->failResponse($error["message"]);

    }


    public function merchantWallet($merchId) {

    $merchant = Merchant::where("id", $merchId)->first();
    $remaining_balance   = ($merchant != null) ? $merchant->getWalletBalance() : 0;
    $maintaining_balance = ($merchant != null) ? $merchant->mb_amount * ($merchant->mb_percent / 100) : 0;

    $temp = array();

    $temp["remaining_balance"] = number_format($remaining_balance,2);
    $temp["maintaining_balance"] = number_format($maintaining_balance,2);   

    if($remaining_balance < $maintaining_balance) 
    {
          $temp["danger"] = "true"; 
    }
    else
    {
          $temp["danger"] = "false"; 
    }
   


    $result = array();

    array_push($result, $temp);

    return $this->successResponse(null, $result);

    }
}
