<?php

namespace App\Http\Controllers\Api\Member;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Point;
use App\Models\PointSetting;
use App\Models\Member;
use App\Models\Referral;
use App\Models\PointHistory;
use App\Models\MerchantWallet;
use App\Models\Merchant;
use App\Models\User;
use App\Models\MemberPointTransactions;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
class CreateController extends Controller
{
    public function index(Request $request) {

        //$buyer_points = 0;
    	//get point settings
    	//$point_settings = PointSetting::where('merchant_id', $request->merchantCode)->whereStatus(1)->first();

        //if($point_settings == null) {
        //   return $this->failResponse( $request->merchantCode."Cannot transact. Please check point settings");

        //}

    	$computed_points = $this->calculatePoints($request->merchantCode, $request->amount);

        $system_data = $computed_points[0]["system_Result"];
        $distributed_data = $computed_points[0]["distributed_Result"];

    
        $merchant = Merchant::where("id", $request->merchantCode)->first();

        $maintaining_balance = ($merchant != null) ? $merchant->mb_amount * ($merchant->mb_percent / 100) : 0;
        $remaining_balance   = ($merchant != null) ? $merchant->getWalletBalance() : 0;

        $sum_value = $distributed_data["value"] + $system_data["value"];
        $temp_res = $remaining_balance - $sum_value;

        /*if($temp_res < $maintaining_balance)
        {
            return $this->failResponse("Merchant Wallet Error", null);
        }*/

    	$point = new Point();
    	$point->point_setting_id = 0;
    	$point->merchant_id = $request->merchantCode;
        $point->user_id = (int)$request->id;
        $point->reference = "REF# : ".strtoupper($request->orNumber);
        $point->amount = $request->amount;
        $point->points = $distributed_data["direct"];
        $point->rebate = $sum_value;
        $point->system = $system_data["value"];
        $point->upline_points = 0;
        $point->accumulated = 0;
        $point->advocacy = $distributed_data['advocacy'];
        $point->cashier_id = auth()->user()->id;
        $point->payment_type = "cash";  

        if (!$point->save()) {
             return $this->failResponse("App ecountered an issue", null);
        }
        

        //SYSTEM MAINTENANCE
        $system_parent_id = config('app.system_maintenance');
        $user_data = User::where('id', $request->id)->first();

        if(strtolower($user_data->firstname) == "testalpha")
        {
            $system_parent_id = '18822';
        }

        $member_data = $this->getMemberStatus($request->id);
        $system = $this->getMember($system_parent_id);
        $data = [
            "earned" => $system->earned + $system_data["value"]  + $distributed_data['advocacy'],
            "total_points" => $system->current_points + $system_data["value"] + $distributed_data['advocacy'],
            "current_points" => $system->current_points + $system_data["value"] + $distributed_data['advocacy']
        ];
        $this->updateReferralPoints($data,$system->user_id);


        MemberPointTransactions::create([

                    'reference_id' => "REF# : ".strtoupper($request->orNumber),
                    'user_id'=> $system_parent_id,
                    'points'=> $system_data["systemMaintenance"],
                    'upline_user_id' => $member_data->user_id,
                    'description' => 'System Maintenance',
                    'type'=> "system_maintenance"

        ]);  

        MemberPointTransactions::create([

                    'reference_id' => "REF# : ".strtoupper($request->orNumber),
                    'user_id'=> $system_parent_id,
                    'points'=> $distributed_data['advocacy'],
                    'upline_user_id' =>  $member_data->user_id,
                    'description' => 'Advocacy',
                    'type'=> "advocacy"

        ]);  

         MemberPointTransactions::create([

                    'reference_id' => "REF# : ".strtoupper($request->orNumber),
                    'user_id'=> $system_parent_id,
                    'points'=> $system_data['hqOperations'],
                    'upline_user_id' =>  $member_data->user_id,
                    'description' => 'HQ Operations',
                    'type'=> "hq_operations"

        ]); 


          MemberPointTransactions::create([

                    'reference_id' => "REF# : ".strtoupper($request->orNumber),
                    'user_id'=> $system_parent_id,
                    'points'=> $system_data['bizCenterOps'],
                    'upline_user_id' =>  $member_data->user_id,
                    'description' => 'Biz Center Ops',
                    'type'=> "biz_center_ops"

        ]); 

    	//unset($computed_points["rebate"]);
    	//unset($computed_points["system"]);

        /*
    	//ADVOCACY POINTS
    	$upline_foundation = config('app.upline_foundation');
    	$advocacy = $this->getMember($upline_foundation);
    	$data = [
    		"earned" => $advocacy->earned + $computed_points["foundation"],
    		"total_points" => $advocacy->current_points + $computed_points["foundation"],
    		"current_points" => $advocacy->current_points + $computed_points["foundation"]
    	];

    	$this->updateReferralPoints($data, $upline_foundation, $request->orNumber, $computed_points["foundation"], $point->id);
    	unset($computed_points["foundation"]);
        

    	$buyer_points = $computed_points["buyer"];
        */

        
        $member = $this->getMemberStatus($request->id);
        $total_points = $member->current_points + $distributed_data["direct"];
        $current_points_total = $member->current_points + $distributed_data["direct"];
        $member_update = Member::where('user_id', $request->id)->update(['total_points' => $total_points,'current_points' => $current_points_total]);


         MemberPointTransactions::create([

                    'reference_id' => "REF# : ".strtoupper($request->orNumber),
                    'user_id'=> $member->user_id,
                    'points'=> $distributed_data["direct"],
                    'upline_user_id' => 0,
                    'description' => 'Loyalty Points',
                    'type'=> "loyalty_points"

        ]);


        $history = [
            "reference" => $request->orNumber,
            "user_id" => $request->id,
            "points" => $distributed_data["direct"],
            "type" => "member_purchase",
            "description" => "Item purchase",
            "point_id" => 0
        ];
        PointHistory::create($history);

        
        $upline_1 = Referral::where('user_id', $member->user_id)->first();
        if($upline_1) {
        	$member_1 = $this->getMember($upline_1->user_upline_id);
        	$data = [
        		"earned" => $member_1->earned + $distributed_data["level1"],
        		"total_points" => $member_1->current_points + $distributed_data["level1"],
        		"current_points" => $member_1->current_points + $distributed_data["level1"]
        	];

             MemberPointTransactions::create([

                    'reference_id' => "REF# : ".strtoupper($request->orNumber),
                    'user_id'=> $member_1->user_id,
                    'points'=> $distributed_data["level1"],
                    'upline_user_id' => $member->user_id,
                    'description' => 'Loyalty Point Commission',
                    'type'=> "loyalty_points_commission"

            ]);

        	$this->updateReferralPoints($data, $member_1->user_id);
        	//unset($distributed_data["level1"]);

        	$upline_2 = Referral::where('user_id', $member_1->user_id)->first();
        	if($upline_2) {
        		$member_2 = $this->getMember($upline_2->user_upline_id);

        		$data = [
	        		"earned" => $member_2->earned + $distributed_data["level2"],
	        		"total_points" => $member_2->current_points + $distributed_data["level2"],
	        		"current_points" => $member_2->current_points + $distributed_data["level2"]
	        	];

                 MemberPointTransactions::create([

                    'reference_id' => "REF# : ".strtoupper($request->orNumber),
                    'user_id'=> $member_2->user_id,
                    'points'=> $distributed_data["level2"],
                    'upline_user_id' => $member->user_id,
                    'description' => 'Loyalty Point Commission',
                    'type'=> "loyalty_points_commission"

                ]);

	        	$this->updateReferralPoints($data, $member_2->user_id);
        		//unset($distributed_data["level2"]);

        		$upline_3 = Referral::where('user_id', $member_2->user_id)->first();
        		if($upline_3) {
        			$member_3 = $this->getMember($upline_3->user_upline_id);

        			$data = [
		        		"earned" => $member_3->earned + $distributed_data['level3'],
		        		"total_points" => $member_3->current_points + $distributed_data['level3'],
		        		"current_points" => $member_3->current_points + $distributed_data['level3']
		        	];

                    MemberPointTransactions::create([

                        'reference_id' => "REF# : ".strtoupper($request->orNumber),
                        'user_id'=> $member_3->user_id,
                        'points'=> $distributed_data["level3"],
                        'upline_user_id' => $member->user_id,
                        'description' => 'Loyalty Point Commission',
                        'type'=> "loyalty_points_commission"

                    ]);

		        	$this->updateReferralPoints($data, $member_3->user_id);
		        	//unset($distributed_data['level3']);

		        	$upline_4 = Referral::where('user_id', $member_3->user_id)->first();
		        	if($upline_4) {
		        		$member_4 = $this->getMember($upline_4->user_upline_id);

		        		$data = [
			        		"earned" => $member_4->earned +$distributed_data['level4'],
			        		"total_points" => $member_4->current_points +$distributed_data['level4'],
			        		"current_points" => $member_4->current_points +$distributed_data['level4']
			        	];

                         MemberPointTransactions::create([

                            'reference_id' => "REF# : ".strtoupper($request->orNumber),
                            'user_id'=> $member_4->user_id,
                            'points'=> $distributed_data["level4"],
                            'upline_user_id' => $member->user_id,
                            'description' => 'Loyalty Point Commission',
                            'type'=> "loyalty_points_commission"

                        ]);


			        	$this->updateReferralPoints($data, $member_4->user_id);
			        	//unset($computed_points["level_4"]);

			        	$upline_5 = Referral::where('user_id', $member_4->user_id)->first();
			        	if($upline_5) {
		        			$member_5 = $this->getMember($upline_5->user_upline_id);

		        			$data = [
				        		"earned" => $member_5->earned + $distributed_data['level5'],
				        		"total_points" => $member_5->current_points + $distributed_data['level5'],
				        		"current_points" => $member_5->current_points + $distributed_data['level5']
				        	];

                             MemberPointTransactions::create([

                                'reference_id' => "REF# : ".strtoupper($request->orNumber),
                                'user_id'=> $member_5->user_id,
                                'points'=> $distributed_data["level5"],
                                'upline_user_id' => $member->user_id,
                                'description' => 'Loyalty Point Commission',
                                'type'=> "loyalty_points_commission"

                            ]);


				        	$this->updateReferralPoints($data, $member_5->user_id);
				        	//unset($distributed_data['level5']);
		        		} //else {
		        		  //	$this->executeLackingReferral($computed_points, $request->orNumber, $point->id);
		        		//}
		        	} //else {
		        		//$this->executeLackingReferral($computed_points, $request->orNumber, $point->id);
		        	//}
        		} //else {
        			//$this->executeLackingReferral($computed_points, $request->orNumber, $point->id);
        		//}
        	} //else {
        		//$this->executeLackingReferral($computed_points, $request->orNumber, $point->id);
        	//}
        } //else {
        	//$this->executeLackingReferral($computed_points, $request->orNumber, $point->id);
        //}
        

        $this->storePointImage($request,$point->id);

        /*
        $data = array(
            "function" => "POINTS",
            "function_id" => (string)$member->user_id,
            "points" => (double)$current_points_total,
            "receivedPoints" => (double)$buyer_points,
            "dateLastUpdated" => (string)date('Y-m-d')
        );

        //Emit Socket
        $this->emitSocket($data);
        */
        // return $this->successResponse($points." points has been added.", null);

        return $this->successResponse($distributed_data["direct"]." points has been added.", null);
    }

    /*public function computePoints($point_settings, $amount) {
    	$points = $point_settings->rebate * $amount / 100;

    	$bayanihan_percent = $point_settings->member / 100;
    	$buyer_percent = $point_settings->member / 100;
    	$bayanihan_points = $points * $bayanihan_percent;

    	$final_result = [
    		"rebate" => $points,
    		"system" => ($amount * ($point_settings->rebate / 100)) * ($point_settings->system / 100),
    		"buyer" => ($buyer_percent * $bayanihan_points) * 2,
    		"level_1" => round(($point_settings->member / 100) * $bayanihan_points, 2 , PHP_ROUND_HALF_UP),
    		"level_2" => round(($point_settings->member / 100) * $bayanihan_points, 2 , PHP_ROUND_HALF_UP),
    		"level_3" => round(($point_settings->member / 100) * $bayanihan_points, 2 , PHP_ROUND_HALF_UP),
    		"level_4" => round(($point_settings->member / 100) * $bayanihan_points, 2 , PHP_ROUND_HALF_UP),
    		"level_5" => round(($point_settings->member / 100) * $bayanihan_points, 2 , PHP_ROUND_HALF_UP),
    		"foundation" => round(($point_settings->advocacy / 100) * $bayanihan_points, 2 , PHP_ROUND_HALF_UP)
    	];

    	return $final_result;
    }
    */

    public function calculatePoints($merchId,$amount) {

        $response_data;
        $token = "eyJhbGciOiJIUzUxMiIsInR5cCI6IkpXVCJ9.eyJuYmYiOjE2NDY5ODQ1MzQsImV4cCI6MTczMzI5ODEzNCwiaWF0IjoxNjQ2OTg0NTM0fQ.ITl5cL-ZQKeqs6_84HWLDgMT2vpaIT5mz1Vb3eTOXIt8iH7HkUkmkYql4edVm5Bs3ePYU44ndj6RBiOu_tuXeQ";

        $response = Http::withToken($token)->post("https://calc.pplus.ph/Calculator/Calculate",[
                'Amount' => strval($amount),
                'MerchantID' => strval($merchId)]);


        if ($response->getStatusCode() == 200) { // 200 OK
             $response_data =  json_decode($response->getBody()->getContents(),true);
        }

        //$system_data = $response_data["data"][0]["system_Result"];
        //$distributed_data = $response_data["data"][0]["distributed_Result"];

       return  $response_data["data"];

    }

    public function executeLackingReferral($levels, $or_number, $point_id) {
    	$levels = array_values($levels);
    	$default_uplines = config('app.default_uplines');
    	foreach ($levels as $key => $level) {
    		$amount = $level/count($default_uplines[$key]);
    		foreach ($default_uplines[$key] as $key => $default_upline) {
		 		$member = $this->getMember($default_upline);
				$data = [
	        		"earned" => $member->earned + $amount,
	        		"total_points" => $member->current_points + $amount,
	        		"current_points" => $member->current_points + $amount
	        	];
	        	$this->updateReferralPoints($data, $member->user_id, $or_number, $amount, $point_id);
    		}
    	}
    }

}
