<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\MerchantCashier;
use App\Models\Merchant;

class ViewController extends Controller
{
    public function index(Request $request) {
    	$credentials = request(['username', 'password']);
    	$credentials["usertype"] = "merchant_cashier";
        $credentials["status"] = 1;

    	if(!auth()->attempt($credentials))
        return $this->failResponse("Invalid username or password.");
    	$merchant_id = MerchantCashier::where('user_id', auth()->user()->id)->first()->merchant_id;
    	$merchant = Merchant::where('id', $merchant_id)->first();

    	$tokenResult = auth()->user()->createToken('PPLUS CASHIER');
        $token = $tokenResult->token;
        $token->save();

    	$data = (Object)[
    		"id" => (string)auth()->user()->id,
    		"firstName" => auth()->user()->firstname,
    		"middleName" => auth()->user()->middlename,
    		"lastName" => auth()->user()->lastname,
    		"merchant" => [
    			"id" => (string)$merchant->id,
    			"name" => $merchant->name
    		],
    		"token" => (string)$tokenResult->accessToken
    	];

    	return $this->successResponse(null,$data);
    }

    public function user() {
        $merchant_id = MerchantCashier::where('user_id', auth()->user()->id)->first()->merchant_id;
        $merchant = Merchant::where('id', $merchant_id)->first();
        $tokenResult = auth()->user()->createToken('PPLUS CASHIER');
        $token = $tokenResult->token;
        $token->save();

        $data = (Object)[
            "id" => (string)auth()->user()->id,
            "firstName" => auth()->user()->firstname,
            "middleName" => auth()->user()->middlename,
            "lastName" => auth()->user()->lastname,
            "merchant" => [
                "id" => (string)$merchant->id,
                "name" => $merchant->name
            ],
            "token" => (string)$tokenResult->accessToken
        ];

        return $this->successResponse(null,$data);
    }
}
