<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Rules\MatchOldPassword;
use Illuminate\Support\Facades\Hash;

use Validator;
use DB;

class UpdateController extends Controller
{
    public function index(Request $request) {
    	$validator = Validator::make($request->all(), [   
            'oldPassword' => ['required', new MatchOldPassword],
            'newPassword' => ['required'],
            'confirmPassword' => ['same:newPassword'],
        ]);

        if ($validator->fails()) { 
        	$errors = array_values($validator->errors()->toArray());
    		return $this->failResponse($errors[0][0]);
        }

        auth()->user()->update(['password' => Hash::make($request->newPassword)]);

        return $this->successResponse("Successfully change password.", null);
    }
}
