<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post("forgot/password", "Api\Auth\ForgotPasswordController@send")->name(
    "forgot.password"
);
Route::get(
    "email/verify/{id}/{hash}",
    "Api\Auth\VerificationController@verify"
)->name("verification.verify");

Route::group(["middleware" => "auth:api"], function () {
    Route::get("apps", "Api\Main\ViewController@index");

    Route::get("promos", "Api\Promos\ViewController@index");
    Route::get("promo/{id}", "Api\Promos\ViewController@getPromo");

    Route::get("conversations", "Api\Conversation\ViewController@index");
    Route::get(
        "conversation/{id}/messages",
        "Api\Conversation\ViewController@messages"
    );
    Route::post(
        "conversation/{id}/message",
        "Api\Conversation\CreateController@index"
    );
});

Route::group(["prefix" => "auth"], function () {
    Route::post("login", "Api\Auth\ViewController@index");
    Route::post("register", "Api\Auth\CreateController@index");
    Route::post("upgradeMember/{id}","Api\Auth\UpdateController@updateMembership");
    Route::group(["middleware" => "auth:api"], function () {
        Route::get("authenticate", "Api\Auth\ViewController@user");

        Route::post("updateProfile", "Api\Auth\UpdateController@index");
        Route::post(
            "updatePassword",
            "Api\Auth\UpdateController@changePassword"
        );
    });
});

Route::group(["prefix" => "user", "middleware" => "auth:api"], function () {
    Route::get("points", "Api\Member\ViewController@index");
    Route::get("transactions", "Api\Member\Transactions\ViewController@index");
    Route::get("referrals", "Api\Member\Referrals\ViewController@index");
    Route::get("notifications", "Api\Member\Notification\ViewController@index");
});

Route::group(["prefix" => "food_app", "middleware" => "auth:api"], function () {
    Route::get("merchants", "Api\Merchant\ViewController@index");
    Route::get("merchant/{id}/items", "Api\Merchant\ViewController@getItems");
    Route::get("merchant/{id}/status", "Api\Merchant\ViewController@getStatus");
    Route::get(
        "merchant/{id}/availableSchedule",
        "Api\Merchant\ViewController@getSchedules"
    );

    //Order
    Route::post("order", "Api\Order\CreateController@index");
    Route::get("orders", "Api\Order\ViewController@index");
    Route::get("order/{id}", "Api\Order\ViewController@getOrder");
    Route::patch("order/{id}", "Api\Order\UpdateController@index");
    Route::patch(
        "order/confirm/{id}/{cash_on_hand}",
        "Api\Order\UpdateController@confirm"
    );
    Route::post("order/{oid}/review", "Api\Order\CreateController@review");

    Route::post(
        "driver/{oid}/review",
        "Api\Driver\Order\CreateController@index"
    );
});

Route::group(
    ["prefix" => "doctor_app", "middleware" => "auth:api"],
    function () {
        Route::get("hospitals", "Api\Hospital\ViewController@index");
        Route::get("hospital/{id}", "Api\Hospital\ViewController@getHospital");

        Route::get("search", "Api\Hospital\ViewController@search");

        Route::get(
            "specialities",
            "Api\Hospital\Speciality\ViewController@index"
        );
        Route::get(
            "speciality/{id}",
            "Api\Hospital\Speciality\ViewController@getSpeciality"
        );

        Route::get("doctor/{id}", "Api\Hospital\Doctor\ViewController@index");
        Route::get(
            "doctor/{id}/reviews",
            "Api\Hospital\Doctor\ViewController@getReviews"
        );
        Route::get(
            "doctor/{id}/bookingSchedule",
            "Api\Hospital\Doctor\ViewController@getBookingSchedule"
        );
        Route::post(
            "doctor/{id}/review",
            "Api\Hospital\Doctor\CreateController@index"
        );

        Route::get(
            "appointments",
            "Api\Hospital\Appointment\ViewController@index"
        );
        Route::post(
            "appointment",
            "Api\Hospital\Appointment\CreateController@index"
        );
        Route::patch(
            "appointment/{id}",
            "Api\Hospital\Appointment\UpdateController@index"
        );
    }
);

Route::group(["prefix" => "driver"], function () {
    Route::post("login", "Api\Auth\Driver\ViewController@index");

    Route::group(["middleware" => "auth:api"], function () {
        Route::get("orders", "Api\Driver\Order\ViewController@index");
        Route::get("order/{id}", "Api\Driver\Order\ViewController@getOrder");
        Route::patch("order/{id}", "Api\Driver\Order\UpdateController@index");
    });
});

Route::get("merchants", "Api\Merchant\ViewController@getMerchants");
// Route::group(['middleware' => 'auth:api'], function () {
// //Member
//    Route::get('member/{id}', 'Api\Member\ViewController@index');
//    Route::post('member/submit', 'Api\Member\CreateController@index');

//    //Promos
//    Route::get('promos', 'Api\Promos\ViewController@index');
//    Route::get('promo/{promo_code}/{merchant_id}/{member_id}', 'Api\Promos\ViewController@getPromo');
//    Route::post('promo/verify', 'Api\Promos\CreateController@index');

// Route::get('authenticate', 'Api\Auth\ViewController@user');
// });
