<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class TransactionOrder extends Model
{
    use ValidatingTrait;

 	protected $fillable = [
        'establishment_id',
		'user_id',
		'driver_id',
		'driver_latitude',
		'driver_longitude',
		'cash_on_hand',
		'notes',
		'payment_method',
		'address',
		'latitude',
		'longitude',
		'reference_id',
        'delivery_amount',
		'status', 
    ];

    protected $rules = [
        'establishment_id'  => 'required|integer', 
        'user_id'  		=> 'required|integer', 
        'driver_id'  		=> 'nullable|integer', 
        'driver_latitude'  	=> 'nullable', 
        'driver_longitude'  => 'nullable', 
		'payment_method'	=> 'required|string', 
		'address'			=> 'required|string', 
		'latitude'			=> 'required', 
		'longitude'			=> 'required', 
		'reference_id'		=> 'required|string', 
		'status'			=> 'required|in:pending,accepted,prepared,cancelled,completed', 
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function order() {
    	return $this->hasOne(Order::class, 'transaction_order_id', 'id');
    }

    public function orders() {
    	return $this->hasMany(Order::class, 'transaction_order_id', 'id');
    }

    public function establishment() {
    	return $this->hasOne(Establishment::class, 'id', 'establishment_id');
    }

    public function review() {
        return $this->hasOne(MerchantReview::class,'transaction_order_id', 'id');
    }

    public function driver_review() {
        return $this->hasOne(DriverReview::class,'transaction_order_id', 'id');
    }

    public function member() {
        return $this->hasOne(Member::class, 'id', 'user_id');
    }

    public function user() {
        return $this->hasOne(Member::class, 'user_id', 'user_id');
    }

    public function account() {
        return $this->hasOne(User::class, 'id', 'user_id');
    }
}
