<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class Referral extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'user_id',
        'user_upline_id',
    ];

    protected $rules = [
        'user_id'         	=> 'required|integer',
        'user_upline_id'    => 'nullable|integer',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function parent()
    {
        return $this->belongsTo(Referral::class, 'user_upline_id','user_id');
    }

    public function children()
    {
        return $this->hasMany(Referral::class,'user_upline_id','user_id');
    }

    public function member() {
        return $this->hasOne(Member::class, 'user_upline_id','user_id');
    }
}
