<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class ProductCategory extends Model
{
     use ValidatingTrait;

 	protected $fillable = [
        'merchant_id', 
        'name',
        'description',
        'status',
    ];

    protected $rules = [
        'merchant_id'   => 'required|integer',
        'name'          => 'required|unique:product_categories,name',
        'description'  	=> 'required|string', 
    ];

    public static function rules()
    {
        return (new static)->rules;
    }
}
