<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class Product extends Model
{
    use ValidatingTrait;

 	protected $fillable = [
        'establishment_id', 
        'product_category_id', 
        'item_code', 
        'name', 
        'description', 
        'price', 
        'status', 
        'auth_by', 
        'approved_by', 
    ];

    protected $rules = [
        'establishment_id'   => 'required|integer', 
        'product_category_id'=> 'required|integer', 
        'item_code'  	     => 'required|string', 
        'name'               => 'required|unique:products,name',
        'description'  	     => 'required|string', 
        'price'  		     => 'required|integer', 
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function product_category() {
        return $this->hasOne(ProductCategory::class, 'id', 'product_category_id');
    }

    public function image() {
        return $this->hasOne(ProductImage::class, 'product_id', 'id');
    }
}