<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class MerchantCashier extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'user_id',
        'merchant_id',
        'cashier_id',
        'employee_number',
        'department',
        'contact_number',
    ];

    protected $rules = [
        'user_id'         	=> 'required|integer',
        'merchant_id'       => 'required|integer',
        'cashier_id'   		=> 'required',
        'employee_number'   => 'required|unique:merchant_cashiers,employee_number',
        'department'       	=> 'required|regex:/^[a-zA-Z\s]*$/',
        'contact_number'    => 'nullable|unique:merchant_cashiers,contact_number',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }
}
