<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class MerchantAgreement extends Model
{
	use ValidatingTrait;

    protected $fillable = [
        'merchant_id',
        'establishment_id',
        'application_type',
        'account_type',
        'service_fee',
        'other_fee',
    ];

    protected $rules = [
        'merchant_id'       => 'required|integer',
        'establishment_id'  => 'required|integer',
        'application_type'  => 'required|in:getta,kol-a',
        'account_type'  	=> 'required|in:group,individual',
        'service_fee'  		=> 'required|integer',
        'other_fee'  		=> 'required|integer',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function paymentMethods()
    {
        return $this->hasMany(PaymentMethod::class, 'merchant_agreement_id');
    }
}
