<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class MemberType extends Model
{
	use ValidatingTrait;

    protected $fillable = [
        'name', 
        'status',
    ];

    protected $rules = [
        'name' => 'required|string|unique:member_types,name',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function member()
    {
        return $this->belongsTo(Member::class, 'member_type_id', 'id');
    }
}
