<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class Member extends Model
{
    use ValidatingTrait;
    
    protected $fillable = [
        'user_id',
        'member_type_id',
        'area_code_id',
        'member_id',
        'account_number',
        'card_number',
        'birthdate',
        'gender',
        'citizenship',
        'marital_status',
        'mobile_number',
        'landline_number',
        'street_address',
        'building',
        'city',
        'province',
        'address',
        'occupation',
        'tin_number',
        'homeownership',
        'total_points',
        'earned',
        'redeemed',
        'referral_points',
        'current_points',
        'amount_expense',
        'verification_code',
        'or_number',
        'referral_code',
        'verification_date',
        'expiration_date',
        'registration_status',
    ];

    protected $dates = [
        'birthdate',
        'verification_date',
        'expiration_date',
    ];
    
    protected $rules = [
        'image'             => 'nullable|mimes:jpeg,jpg,png|max:10000',
        'user_id'           => 'required|integer',
        'member_type_id'    => 'required|integer',
        'member_id'         => 'required|unique:members,member_id',
        'account_number'    => 'nullable|unique:members,account_number',
        'birthdate'         => 'required|date',
        'gender'            => 'required|in:Male,Female',
        'marital_status'    => 'required|in:Single,Married,Divorced,Widowed,Select Marital Status',
        'citizenship'       => 'required|regex:/^[a-zA-Z\s]*$/',
        'mobile_number'     => 'required',
        'occupation'        => 'required|regex:/^[a-zA-Z\s]*$/',
        'address'           => 'required',
        'homeownership'     => 'nullable|regex:/^[a-zA-Z\s]*$/',
        'referral_code'     => 'required|unique:members,referral_code',      
        'verification_date' => 'nullable|date',
        'expiration_date'   => 'nullable|date',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }

    public function member_type()
    {
        return $this->hasOne(MemberType::class, 'id', 'member_type_id');
    }

    public function user_image()
    {
        return $this->hasMany(UserImage::class, 'auth_by', 'user_id');
    }
}
