<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class EstablishmentSchedule extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'establishment_id',
        'monday',
        'tuesday',
        'wednesday',
        'thursday',
        'friday',
        'saturday',
        'sunday',
    ];
    
    protected $rules = [
        'establishment_id'  => 'required|integer|unique:establishment_schedules,establishment_id',
        'monday'	 		=> 'nullable',       
        'tuesday'	 		=> 'nullable',       
        'wednesday'	 		=> 'nullable',       
        'thursday'	 		=> 'nullable',       
        'friday'	 		=> 'nullable',       
        'saturday'	 		=> 'nullable',       
        'sunday'	 		=> 'nullable',       
    ];

    public static function rules()
    {
        return (new static)->rules;
    }
}
