<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class Establishment extends Model
{
	use ValidatingTrait;

    protected $fillable = [
        'merchant_id',
        'merchant_type_id',
        'name',
        'address',
        'latitude',
        'longitude',
        'description',
        'status',
    ];

    protected $rules = [
        'merchant_id'       => 'required|integer',
        'merchant_type_id'  => 'required|integer',
        'name' 			    => 'required|string|unique:establishments,name',
        'address'           => 'required|string',
        'latitude'  	    => 'nullable',
        'longitude'  	    => 'nullable',
        'description'  	    => 'required|string',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function image()
    {
        return $this->hasOne(EstablishmentImage::class, 'establishment_id');
    }

    public function merchant() {
        return $this->hasOne(Merchant::class, 'id', 'merchant_id');
    }

    public function products() {
        return $this->hasMany(Product::class, 'establishment_id', 'id');
    }

    public function establishment_schedule() {
        return $this->hasOne(EstablishmentSchedule::class, 'establishment_id', 'id');
    }

    public function doctors() {
        return $this->hasMany(Doctor::class,'merchant_id','merchant_id');
    }

    public function driver() {
        return $this->hasOne(Driver::class,'merchant_id','merchant_id');
    }
}
