<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class Driver extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'user_id',
        'merchant_id',
        'professional_id',
        'contact_number',
        'vehicle_id',
    ];
    
    protected $rules = [
        'user_id'      		=> 'required|integer',
        'merchant_id'      	=> 'nullable|integer',
        'professional_id'	=> 'required|string',     
        'contact_number'	=> 'required|string',     
        'vehicle_id'        => 'required|integer',     
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function image()
    {
        return $this->belongsTo(DriverImage::class, 'id', 'driver_id');
    }

    public function user() {
        return $this->hasOne(User::class,'id','user_id');
    }

    public function vehicle() {
        return $this->hasOne(Vehicle::class, 'id', 'vehicle_id');
    }

    // public function driver_review() {
    //     return $this->hasOne(DriverReview::class, 'driver_id', 'user_id');
    // }
}
