<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class DoctorSpeciality extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'doctor_id',
        'speciality_id',
    ];
    
    protected $rules = [
        'doctor_id'      => 'required|integer',
        'speciality_id'	 => 'required|integer',       
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function speciality()
    {
        return $this->belongsTo(Speciality::class, 'speciality_id');
    }

    public function specialty()
    {
        return $this->hasOne(Speciality::class, 'id','speciality_id');
    }

    public function doctor() {
        return $this->hasOne(Doctor::class, 'doctor_id');
    }
}
