<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class DoctorReview extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'appointment_id',
        'rate',
        'comment',
        'user_id'
    ];
    
    protected $rules = [
        'appointment_id'	=> 'required|integer',
        'rate'	 			=> 'required|in:1,2,3,4,5',       
        'comment'	 		=> 'nullable|string',    
        'user_id'         => 'required|integer'   
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function member() {
        return $this->hasOne(Member::class, 'user_id','user_id');
    }
}
