<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class DoctorAppointment extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'doctor_id',
        'user_id',
        'appointment_id',
        'date_time',
        'reference_id',
        'payment_method',
        'hmo_id',
        'status',
    ];
    
    protected $rules = [
        'doctor_id'		=> 'required|integer',
        'user_id'		=> 'required|integer',
        'date_time'	 	=> 'required|date_format:Y-m-d H:i:s', 
        'reference_id'  => 'required|string',
        'payment_method'=> 'required|string',
        'status'        => 'required|in:pending,approved,declined,cancelled,completed',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function doctorReview() {
        return $this->hasOne(DoctorReview::class, 'appointment_id');
    }

    public function member() {
        return $this->hasOne(Member::class, 'user_id','user_id');
    }

    public function doctor() {
        return $this->hasOne(Doctor::class, 'user_id', 'doctor_id');
    }
}
