<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class Doctor extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'user_id',
        'merchant_id',
        'professional_id',
        'prefix',
        'contact_number',
        'minimum_consultation_fee',
        'maximum_consultation_fee',
    ];
    
    protected $rules = [
        'user_id'      				=> 'required|integer',
        'merchant_id'				=> 'required|integer',
        'professional_id'   		=> 'required|string',
        'prefix'            		=> 'required|string',       
        'contact_number'            => 'required',       
        'minimum_consultation_fee' 	=> 'required|integer',
        'maximum_consultation_fee'  => 'required|integer',         
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function account() {
        return $this->hasOne(User::class,'id', 'user_id');
    }

    public function image()
    {
        return $this->belongsTo(DoctorImage::class, 'id', 'doctor_id');
    }

    public function doctorSpecialities()
    {
        return $this->hasMany(DoctorSpeciality::class, 'doctor_id');
    }

    public function doctorPaymentMethods()
    {
        return $this->hasMany(DoctorPaymentMethod::class, 'doctor_id');
    }

    public function doctorAppointments() {
        return $this->hasMany(DoctorAppointment::class, 'doctor_id');
    }

    public function merchant() {
        return $this->hasOne(Merchant::class,'id');
    }

    public function doctor_schedule() {
        return $this->hasOne(DoctorSchedule::class, 'doctor_id');
    }
}
