<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class BayanihanPointSetting extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'points', 
        'status',
    ];

    protected $rules = [
        'points' 	=> 'required|integer|unique:bayanihan_point_settings,points',
        'status'    => 'nullable|in:0,1',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }
}
