<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class AdminAccount extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'user_id',
        'employee_number',
        'department',
        'contact_number',
    ];

    protected $rules = [
        'image'         	=> 'nullable|mimes:jpeg,jpg,png|max:10000',
        'user_id'           => 'required|integer',
        'employee_number'   => 'required|string|unique:admin_accounts,employee_number',
        'department'       	=> 'required|regex:/^[a-zA-Z\s]*$/',
        'contact_number'    => 'nullable|unique:admin_accounts,contact_number',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }
}
