<?php

namespace App\Http\Controllers\Api\Promos;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Promotion;
use App\Models\PromotionLog;

class ViewController extends Controller
{
    public function index() {
    	$promotions = Promotion::whereStatus(1)->where('date_start','<=', now())->where('date_end','>=', now())->orderBy('created_at','desc')->get();
    	$data = [];

    	foreach ($promotions as $key => $promo) {
    		if(count($promo->promoMembers) > 0) {
    			$promo_member_count = $promo->promoMembers->where('member_id', auth()->user()->member->id)->count();
    			if($promo_member_count == 0) {
    				continue;
    			}
    		}
    		if(count($promo->promoMemberTypes) > 0) {
    			$promo_member_type_count = $promo->promoMemberTypes->where('member_type_id', auth()->user()->member->member_type_id)->count();
    			if($promo_member_type_count == 0) {
    				continue;
    			}
    		}

    		$promotion_logs_quantity = PromotionLog::where('promo_id', $promo->id)->get();

    		$allocation_amount = (isset($promotion_logs_quantity->allocation_amount)) ? $promotion_logs_quantity->allocation_amount : 0;
    		$points_amount = (isset($promotion_logs_quantity->points_amount)) ? $promotion_logs_quantity->points_amount : 0;
    		$quantity = (int)$promo->quantity - (int)count($promotion_logs_quantity);

    		$data[] = [
    			"id" => (string)$promo->id,
    			"merchant" => [
    				"name" => $promo->merchant->name,
    				"logo" => isset($promo->merchant->images[0]->path) ? config('app.AWS_BUCKET_URL').$promo->merchant->images[0]->path : null
    			],
	            "bannerUrl" => isset($promo->promoImages[0]->path) ? config('app.AWS_BUCKET_URL').$promo->promoImages[0]->path : null,
	            "title" => $promo->description,
	            "availability" => [
	                "dateExpiry" => $promo->date_end->format('F d, Y')
	            ]
    		];
    	}

    	return $this->successResponse(null, $data);	
    }

    public function getPromo($id) {
		$promotions = Promotion::whereStatus(1)->where('id', $id)->where('date_start','<=', now())->where('date_end','>=', now())->first();
		$promotion_logs_quantity = PromotionLog::where('promo_id', $id)->get();
		$quantity = (int)$promotions->quantity - count($promotion_logs_quantity);
    	$data = [
    		"code" => $promotions->promo_code,
	        "imageUrl" => isset($promotions->promoImages[0]->path) ? config('app.AWS_BUCKET_URL').$promotions->promoImages[0]->path : null,
	        "content" => $promotions->description,
	        "availability" => [
	            "quantity" => $quantity,
	            "backgroundColor" => $this->getPromoBackgroundColor($promotions->quantity, $quantity)
	        ]
    	];

    	return $this->successResponse(null, $data);	
    }

    public function getPromoBackgroundColor($total, $available) {
	  	// Threshold
	  	// (0xFF4CAF50)Green = 25-100%
	  	// (0xFFF57F17)Yellow = 25% below
	  	// (0xFFF44336)Red = 0

	  	$percentage = ($available / $total) * 100;

	  	if ($percentage >= 25) {
	    	return 0xFF4CAF50;
	  	} else if ($percentage > 0 && $percentage < 25) {
	    	return 0xFFF9A825;
	  	} else {
	    	return 0xFFF44336;
	  	}
	}
}
