<?php

namespace App\Http\Controllers\Api\Promos;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Promotion;
use App\Models\PromotionLog;
use App\Models\Member;

class CreateController extends Controller
{
    public function index(Request $request) {
    	$partial_code = explode("-", $request->voucherCode);
    	$voucher_code = $partial_code[0];
    	$amount = (isset($partial_code[1])) ? $partial_code[1] : null;

    	$availability = $this->getPromoAvailability($voucher_code);

    	if($availability["availability"] == false) {
    		$error = [
    			"field" => "voucherCode",
    			"message" => "This offer is not available."
    		];
    		return $this->failResponse($error["message"]);
    	}

    	if($availability["points_as_payment"] == 1) {
    		$member = $this->getMemberStatus($request->memberId);

    		if($member->registration_status == 'unverified') {
    			$error = [
	    			"field" => "voucherCode",
	    			"message" => "Associate Members cannot avail Points as Payment."
	    		];
	    		return $this->failResponse($error["message"]);
    		}

    		if(!isset($partial_code[1]) || !isset($partial_code[0])) {
    			$error = [
	    			"field" => "voucherCode",
	    			"message" => "Please enter the amount of points after the dash(-)."
	    		];
	    		return $this->failResponse($error["message"]);
    		}

    		if($this->countDecimals($partial_code[1]) > 2) {
    			$error = [
	    			"field" => "voucherCode",
	    			"message" => "Points must not contain 3 or more decimals.\neg. CODE-50.75"
	    		];
	    		return $this->failResponse($error["message"]);
    		}

    		if($partial_code[1] == 0) {
    			$error = [
	    			"field" => "voucherCode",
	    			"message" => "Please enter a valid amount of points."
	    		];
	    		return $this->failResponse($error["message"]);
    		}

    		if($partial_code[1] > $member->current_points) {
    			$error = [
	    			"field" => "voucherCode",
	    			"message" => "Cannot verify this voucher. The amount you have entered is higher than the member's current points.\n Points to be Deducted: ".$partial_code[1]." Current Points: ".$member->current_points.""
	    		];
	    		return $this->failResponse($error["message"]);
    		}

    		if($partial_code[1] > $availability["remainingAllocation"]) {
    			$error = [
	    			"field" => "voucherCode",
	    			"message" => "Cannot verify this voucher. The remaining allocation for this offer cannot accomodate more than ".$availability["remainingAllocation"].". Please enter ".$availability["remainingAllocation"]." or below in points as payment amount."
	    		];
	    		return $this->failResponse($error["message"]);
    		}

    		$member_points = (double)$member->current_points - (double)$partial_code[1];

    		$member = Member::find($request->memberId);
    		$member->current_points = (int)$member_points;
    		$member->save();
    		
    		$promotion_log = new PromotionLog();
    		$promotion_log->promo_id = (int)$availability["id"];
	        $promotion_log->member_id = (int)$request->memberId;
	        $promotion_log->user_id = auth()->user()->id;
	        $promotion_log->allocation_amount_before = (double)$availability["remainingAllocation"];
	        $promotion_log->points_amount = (double)$partial_code[1];
	        $promotion_log->save();
    	} else {
    		$promotion_log = new PromotionLog();
    		$promotion_log->promo_id = (int)$availability["id"];
	        $promotion_log->member_id = (int)$request->memberId;
	        $promotion_log->user_id = auth()->user()->id;
	        $promotion_log->allocation_amount_before = (double)$availability["remainingAllocation"];
	        $promotion_log->save();
    	}

    	return $this->successResponse("Voucher has been verified.", null);
    }
}
