<?php

namespace App\Http\Controllers\Api\Order;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\TransactionOrder;
use App\Models\Driver;

class ViewController extends Controller
{
    public function index() {
    	$transaction_orders = TransactionOrder::where('user_id', auth()->user()->id)->orderBy('created_at', 'desc')->get();
    	$data = [];
    	foreach ($transaction_orders as $key => $transaction_order) {
    		$totalPrice = isset($transaction_order->delivery_amount) ? $transaction_order->delivery_amount : 0;
    		foreach ($transaction_order->orders as $order) {
    			$totalPrice += isset($order->product->price) ? $order->product->price * $order->quantity : 0;
    		}

    		$data[] = [
	    		"id" => str_replace("REF#:","",$transaction_order->reference_id),
		        "merchant" => [
		            "id" => (string)$transaction_order->establishment->id,
		            "name" => $transaction_order->establishment->name,
		            "location" => [
		                "latitude" => (double)$transaction_order->establishment->latitude,
		                "longitude" => (double)$transaction_order->establishment->longitude,
		                "address" => $transaction_order->establishment->address
		            ]
		        ],
		        "deliveryLocation" => [
		            "latitude" => (double)$transaction_order->latitude,
		            "longitude" => (double)$transaction_order->longitude,
		            "address" => $transaction_order->address
		        ],
		        "totalItems" => $transaction_order->orders->count(),
		        "totalPrice" => $totalPrice,
		        "status" => ($transaction_order->status == "completed") ? "DELIVERED" : strtoupper($transaction_order->status),
		        "dateOrdered" => $transaction_order->created_at->format('Y-m-d H:i:s')
		    ];
    	}
    	return $this->successResponse('Success', $data);
    }

    public function getOrder($id) {
    	$id = "REF#:".$id;
    	$transaction_order = TransactionOrder::select('transaction_orders.*')->where('reference_id', $id)->first();
    	$items = [];
    	foreach ($transaction_order->orders as $key => $order) {
    		$items[] = [
    			"item" => [
	                "id" => (string)$order->product->id,
	                "name" => $order->product->name,
	                "imageUrl" => isset($order->product->image->path) ? config('app.AWS_BUCKET_URL').$order->product->image->path : null,
	                "description" => $order->product->description,
	                "price" => (double)$order->product->price
	            ],
	            "quantity" => (int)$order->quantity
    		];
    	}
    	$data = [
	        "id" => str_replace("REF#:","",$transaction_order->reference_id),
	        "merchant" => [
	            "id" => (string)$transaction_order->establishment->id,
	            "imageUrl" => isset($transaction_order->establishment->image->path) ? config('app.AWS_BUCKET_URL').$transaction_order->establishment->image->path : null,
	            "name" => $transaction_order->establishment->name,
	            "location" => [
	                "latitude" => (double)$transaction_order->establishment->latitude,
	                "longitude" => (double)$transaction_order->establishment->longitude,
	                "address" => $transaction_order->establishment->address
	            ]
	        ],
	        "deliveryLocation" => [
	            "latitude" => (double)$transaction_order->latitude,
	            "longitude" => (double)$transaction_order->latitude,
	            "address" => $transaction_order->address
	        ],
	        "items" => $items,
	        "cashOnHand" => (double)$transaction_order->cash_on_hand,
	        "status" => ($transaction_order->status == "completed") ? "DELIVERED" : strtoupper($transaction_order->status),
	        "dateOrdered" => $transaction_order->created_at->format('Y-m-d H:i:s'),
	        "mode" => "ASAP",
	        "notes" => $transaction_order->notes,
	        "paymentMethod" => str_replace(" ","",strtoupper($transaction_order->payment_method)),
	        "deliveryFee" => (double)$transaction_order->delivery_amount
	    ];

	    if($transaction_order->driver_id != null) {
	    	$driver = Driver::where('id', $transaction_order->driver_id)->first();

	    	$data["driver"] = [
	    		"vehicle" => [
	    			"id" => (string)$driver->vehicle->id,
	    			"make" => $driver->vehicle->model,
	    			"plateNumber" => $driver->vehicle->plate_number
	    		],
	    		"id" => (string)$driver->user_id,
	    		"cardNumber" => null,
	    		"firstName" => $driver->user->firstname,
	    		"mi" => (isset($driver->user->middlename[0])) ? $driver->user->middlename[0] : null,
	    		"lastName" => $driver->user->lastname,
	    		"contactNumber" => $driver->contact_number,
	    		"emailAddress" => $driver->user->email,
	    		"address" => null,
	    		"username" => $driver->user->username,
	    		"imageUrl" => isset($driver->image->url) ? $driver->image->url : null
	    	];
	    	
	    	if($transaction_order->driver_review != null) {
	    		$data["driver"]["review"] = [
		    		"id" => (string)$transaction_order->driver_review->id,
		    		"rating" => (double)$transaction_order->driver_review->rate,
		    		"content" => $transaction_order->driver_review->comment,
		    	];
	    	}
	    	
	    } 

	    if($transaction_order->review != null) {
	    	$data["review"] = [
	    		"id" => (string)$transaction_order->review->id,
	    		"rating" => (double)$transaction_order->review->rate,
	    		"content" => $transaction_order->review->comment,
	    	];
	    }

	    return $this->successResponse("Order retrieved.",$data);
    }
}
