<?php

namespace App\Http\Controllers\Api\Order;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\TransactionOrder;
use App\Models\MerchantReview;

class CreateController extends Controller
{
    public function index(Request $request) {
    	if($request->deliveryLocation["address"] == "Current Location\nnull") {
    		$deliveryLocation = "Pinned Location";
    	} else {
    		$deliveryLocation = $request->deliveryLocation["address"];
    	}

    	$params  = [
	        'establishment_id' => $request->merchantId,
			'user_id' => auth()->user()->id,
			'driver_id' => null,
			'driver_latitude' => null,
			'driver_longitude' => null,
			'cash_on_hand' => 0,
			'notes' => $request->mode." ".$request->notes,
			'payment_method' => $request->paymentMethod,
			'address' => $deliveryLocation,
			'latitude' => $request->deliveryLocation["latitude"],
			'longitude' => $request->deliveryLocation["longitude"],
			'reference_id' => $this->generateReferenceId(),
			'status' => 'pending'
	    ];

	    $transaction_order = new TransactionOrder($params);
	    $transaction_order->save();
	    $items = $request->items;
	    foreach ($items as $key => $item) {
	    	$order_params = [
	    		'transaction_order_id' => $transaction_order->id,
		        'product_id' => $key,
		        'quantity' => $item,
	    	];
	    	$transaction_order->orders()->create($order_params);
	    }

    	return $this->successResponse('We have received your order request. We will contact you to confirm your order.', null);
    }

    public function review(Request $request) {
    	$id = "REF#:".$request->oid;
    	$transaction_order = TransactionOrder::where('reference_id', $id)->first();

    	$params = [
    		'member_id' => auth()->user()->id,
	        'merchant_id' => $request->id,
	        'transaction_order_id' => $transaction_order->id,
	        'rate' => $request->rating,
	        'comment' => $request->content
    	];

    	$merchant_review = new MerchantReview($params);
    	$merchant_review->save();

    	return $this->successResponse("Rating and review save.", null);
    }

    public function generateReferenceId() {
    	$length = 10;    
		$reference_id = "REF#:".substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'),1,$length);
    	return $reference_id;
    }
}
