<?php

namespace App\Http\Controllers\Api\Merchant;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Carbon\CarbonPeriod;

//use Models
use App\Models\Establishment;
use App\Models\EstablishmentSchedule;
use App\Models\Product;
use App\Models\Merchant;

class ViewController extends Controller
{
    public function index(Request $request) {
    	// DO NOT DELETE USABLE IN FUTURE DEVELOPMENT
    	// $establishments = Establishment::selectRaw('*, ( 6367 * acos( cos( radians( ? ) ) * cos( radians( latitude ) ) * cos( radians( longitude ) - radians( ? ) ) + sin( radians( ? ) ) * sin( radians( latitude ) ) ) ) AS distance', [$request->lat, $request->lng, $request->lat])
	    // ->having('distance', '<', 2)
	    // ->orderBy('distance')
	    // ->get();
	    //END HERE

    	$establishments = Establishment::select('establishments.*')->join('merchant_types', 'establishments.merchant_type_id', 'merchant_types.id')->join('merchants','establishments.merchant_id','merchants.id')
        ->whereIn('merchant_types.name',['Food and Beverage', 'Restaurant', 'Food'])
        ->where('establishments.status', 1)
        ->where('merchants.date_end','>=', Carbon::now())
        ->get();

    	$data = [];
    	foreach ($establishments as $key => $establishment) {
    		$attributes = [];
    		foreach ($establishment->products as $key => $product) {
    			$attributes[] = ucwords($product->product_category->name);
    		}

    		$data[] = [
    			"id" => (string)$establishment->id,
    			"name" => $establishment->name,
    			"imageUrl" => isset($establishment->image->path) ? config('app.AWS_BUCKET_URL').$establishment->image->path : null,
    			"attributes" => $attributes,
    			"location" => [
    				"latitude" => (double)$establishment->latitude,
                	"longitude" => (double)$establishment->longitude,
                	"address" => $establishment->address
    			],
    			// "isClosed" => $this->checkClosed($establishment->establishment_schedule),
                "isClosed" => false,
    			"timings" => [
    				"times" => array_values($this->getTimes($establishment->establishment_schedule)),
    				"currentDayTimeIndex" => (int) date('w', strtotime('Today'))
    			]
    		];
    	}
    	return $this->successResponse("success", $data);
    }

    public function getItems($id) {
    	$items = Product::where('establishment_id',$id)->whereStatus(1)->get();
    	$data = [];
    	foreach ($items as $key => $item) {
    		if(array_key_exists($item->product_category->name,$data)) {
    			$data[$item->product_category->name]["items"][] = [
    				"id" => (string)$item->id,
	                "name" => ucwords($item->name),
	                "imageUrl" => isset($item->image->path) ? config('app.AWS_BUCKET_URL').$item->image->path : null,
	                "description" => $item->description,
	                "price" => (double)$item->price
    			];
    		} else {
    			$data[$item->product_category->name] = [
	    			"id" => (string)$item->product_category_id,
	    			"name" => ucwords($item->product_category->name),
	    			"items" => [
	    				[
		    				"id" => (string)$item->id,
			                "name" => $item->name,
			                "imageUrl" => isset($item->image->path) ? config('app.AWS_BUCKET_URL').$item->image->path : null,
			                "description" => $item->description,
			                "price" => (double)$item->price
			            ]
	    			]
	    		];
    		}
    	}

        if(count($data) != 0) {
            return $this->successResponse("Success", array_values($data));
        }

        return $this->successResponse("Success", (object)$data);
    	
    }

    public function getStatus($id) {
    	$establishment = Establishment::find($id);

    	// $status = $this->checkClosed($establishment->establishment_schedule);
        $status = false;
    	if($status == false) {
    		return $this->successResponse("ok", null);
    	}
        $data = (object)[
            "isClosed" => true
        ];
        return $this->successResponse("ok", $data);
    }

    public function getSchedules($id) {
    	$now = Carbon::now();
        $start = $now->format('w') == 0 ? 'Today' : 'last sunday';
        $counter = Carbon::parse($start);
        $startDate = Carbon::parse($start);  
        $endDate = Carbon::parse($start)->addDays(13);


    	$establishment_schedule = EstablishmentSchedule::find($id);
    	$schedules = $this->getTimes($establishment_schedule);

    	$map = [];
    	for($i = -1; $i <= 12; $i++) {
    		$date = Carbon::parse($start)->addDays($i + 1);
    		$schedule_selected = $schedules[strtolower($date->isoFormat('dddd'))];

    		if($schedule_selected !== null) {
    			$am_time = explode(" - ", $schedule_selected[0]);
	    		$pm_time = explode(" - ", $schedule_selected[1]);
	    		$am_start = isset($am_time[0]) ? $am_time[0] : null;
	    		$am_end = isset($am_time[1]) ? $am_time[1] : null;
	    		$pm_start = isset($pm_time[0]) ? $pm_time[0] : null;
	    		$pm_end = isset($pm_time[1]) ? $pm_time[1] : null;

	    		$am_startTime = new Carbon($am_start);
				$am_endTime = new Carbon($am_end);

				$am_time_array = array();
				while ($am_startTime->lte($am_endTime)){
				  	$am_time_array[] = $am_startTime->format("h:i A");
				  	$am_startTime->addHour();
				}

				$pm_startTime = new Carbon($pm_start);
				$pm_endTime = new Carbon($pm_end);
				$pm_time_array = array();
				while ($pm_startTime->lte($pm_endTime)){
				  	$pm_time_array[] = $pm_startTime->format("h:i A");
				  	$pm_startTime->addHour();

				}

				$time_array = array_merge($am_time_array, $pm_time_array);

				$map[][$date->toDateString()] = $time_array;
    		} else {
    			$map[][$date->toDateString()] = null;
    		}

    	}

        $data = [ 
            'startDate' => $startDate->toDateString(),
            'endDate' => $endDate->toDateString(), 
            'initialDate' => $now->toDateString(),
            'selectableDates' => $map, 
        ];
        return $this->successResponse("Available schedule for ".$id, $data);
    }

    public function checkClosed($schedules) {
    	$currentIndex = (int)date('w', strtotime('Today')) - 1;

    	$schedule_monday = ($schedules["monday"] != null ) ? str_replace(["[", "]"],"",explode("] - [", $schedules["monday"])) : null;
    	$schedule_tuesday = ($schedules["tuesday"] != null ) ? str_replace(["[", "]"],"",explode("] - [", $schedules["tuesday"])) : null;
    	$schedule_wednesday = ($schedules["wednesday"] != null ) ? str_replace(["[", "]"],"",explode("] - [", $schedules["wednesday"])) : null;
    	$schedule_thursday = ($schedules["thursday"] != null ) ? str_replace(["[", "]"],"",explode("] - [", $schedules["thursday"])) : null;
    	$schedule_friday = ($schedules["friday"] != null ) ? str_replace(["[", "]"],"",explode("] - [", $schedules["friday"])) : null;
    	$schedule_saturday = ($schedules["saturday"] != null ) ? str_replace(["[", "]"],"",explode("] - [", $schedules["saturday"])) : null;
    	$schedule_sunday = ($schedules["sunday"] != null ) ? str_replace(["[", "]"],"",explode("] - [", $schedules["sunday"])) : null;

    	$schedules = [
    		$schedule_monday,
    		$schedule_tuesday,
    		$schedule_wednesday,
    		$schedule_thursday,
    		$schedule_friday,
    		$schedule_saturday,
    		$schedule_sunday
    	];

    	if($schedules[$currentIndex][0] == null || $schedules[$currentIndex][1] == null) {
    		return true;
    	}

    	if(date('A') == "AM") {
    		$time = explode(" - ", $schedules[$currentIndex][0]);
    		$start_time = isset($time[0]) ? strtotime($time[0]) : null;
    		$end_time = isset($time[1]) ? strtotime($time[1]) : null;

    		if(time() >= $start_time && time() <= $end_time) {
			  	return false;
			} else {
			  	return true;
			}
    	} else {
            $time_am = explode(" - ", $schedules[$currentIndex][0]);
            $start_time_am = isset($time[0]) ? strtotime($time_am[0]) : null;
            $end_time_am = isset($time_am[1]) ? strtotime($time_am[1]) : null;

            $meredian = date('A', $end_time_am);
            if($meredian == "PM") {
                if(time() <= $end_time_am) {
                    return false;
                }
            }

    		$time = explode(" - ", $schedules[$currentIndex][1]);
    		$start_time = isset($time[0]) ? strtotime($time[0]) : null;
    		$end_time = isset($time[1]) ? strtotime($time[1]) : null;

    		if(time() >= $start_time && time() <= $end_time) {
			  	return false;
			} else {
			  	return true;
			}
    	}
    }

    public function getMerchants() {
        $merchant = Merchant::select('id','name','date_start','date_end')
        // ->whereDate('date_end', '>=', date('Y-m-d').' 00:00:00')
        ->get();
        return $this->successResponse("Success", $merchant);
    }
}
