<?php

namespace App\Http\Controllers\Api\Member;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Member;
use App\Models\Referral;
use App\Models\User;
use DB;

class ViewController extends Controller
{
    public function index()
    {
        $points = $this->computePoints();
        $data = [
            "totalReferrals" => round(
                $points["totalReferrals"],
                2,
                PHP_ROUND_HALF_UP
            ),
            "redeemed" => round($points["redeemed"], 2, PHP_ROUND_HALF_UP),
            "totalpoints" => round(
                $points["totalpoints"],
                2,
                PHP_ROUND_HALF_UP
            ),
            "points" => round($points["redeemable"], 2, PHP_ROUND_HALF_UP),
            "pending" => round($points["pending"], 2, PHP_ROUND_HALF_UP),
            "dateLastUpdated" => date(
                "Y-m-d H:i:s",
                strtotime(auth()->user()->member->updated_at)
            ),
        ];

        return $this->successResponse(null, $data);
    }

    public function computePoints()
    {

        $referralsCount = Referral::where("user_upline_id", auth()->user()->id)->count();

        $referral_counter = 0;
        $referrals = Referral::where("user_upline_id", auth()->user()->id)->get();
        foreach ($referrals as $key) {
           
            $check_membertype = Member::where("user_id", $key->user_id)
                                        ->where(function ($query) {
                                        $query->where('registration_status', '=', 'Regular')
                                              ->orWhere('registration_status', '=', 'unverified');
                                    })->count();

                if($check_membertype > 0){

                    $referral_counter++;

                }
            
        }

        $bayanihan_points = DB::table("bayanihan_point_settings")
            ->select("points")
            ->where("status", 1)
            ->first();



        $pending = $bayanihan_points->points * $referral_counter;

        return [
            "redeemable" => auth()->user()->member->current_points,
            "totalpoints" => auth()->user()->member->total_points,
            "redeemed" => auth()->user()->member->redeemed,
            "pending" => $pending,
            "totalReferrals" => $referralsCount,
        ];
    }
}
